<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasterprojectUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterproject: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fmasterprojectupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmasterprojectupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["ProjectName", [fields.ProjectName.visible && fields.ProjectName.required ? ew.Validators.required(fields.ProjectName.caption) : null], fields.ProjectName.isInvalid],
            ["PlanStart", [fields.PlanStart.visible && fields.PlanStart.required ? ew.Validators.required(fields.PlanStart.caption) : null, ew.Validators.datetime(fields.PlanStart.clientFormatPattern), ew.Validators.selected], fields.PlanStart.isInvalid],
            ["PlanEnd", [fields.PlanEnd.visible && fields.PlanEnd.required ? ew.Validators.required(fields.PlanEnd.caption) : null, ew.Validators.datetime(fields.PlanEnd.clientFormatPattern), ew.Validators.selected], fields.PlanEnd.isInvalid],
            ["StartDate", [fields.StartDate.visible && fields.StartDate.required ? ew.Validators.required(fields.StartDate.caption) : null, ew.Validators.datetime(fields.StartDate.clientFormatPattern), ew.Validators.selected], fields.StartDate.isInvalid],
            ["EndDate", [fields.EndDate.visible && fields.EndDate.required ? ew.Validators.required(fields.EndDate.caption) : null, ew.Validators.datetime(fields.EndDate.clientFormatPattern), ew.Validators.selected], fields.EndDate.isInvalid],
            ["WarrantyEnd", [fields.WarrantyEnd.visible && fields.WarrantyEnd.required ? ew.Validators.required(fields.WarrantyEnd.caption) : null, ew.Validators.datetime(fields.WarrantyEnd.clientFormatPattern), ew.Validators.selected], fields.WarrantyEnd.isInvalid],
            ["Status", [fields.Status.visible && fields.Status.required ? ew.Validators.required(fields.Status.caption) : null], fields.Status.isInvalid],
            ["Target", [fields.Target.visible && fields.Target.required ? ew.Validators.required(fields.Target.caption) : null, ew.Validators.float, ew.Validators.selected], fields.Target.isInvalid],
            ["Track", [fields.Track.visible && fields.Track.required ? ew.Validators.required(fields.Track.caption) : null], fields.Track.isInvalid],
            ["PaymentDate", [fields.PaymentDate.visible && fields.PaymentDate.required ? ew.Validators.required(fields.PaymentDate.caption) : null], fields.PaymentDate.isInvalid],
            ["AgingPayment", [fields.AgingPayment.visible && fields.AgingPayment.required ? ew.Validators.required(fields.AgingPayment.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.AgingPayment.isInvalid],
            ["ClientID", [fields.ClientID.visible && fields.ClientID.required ? ew.Validators.required(fields.ClientID.caption) : null], fields.ClientID.isInvalid],
            ["ManagerID", [fields.ManagerID.visible && fields.ManagerID.required ? ew.Validators.required(fields.ManagerID.caption) : null], fields.ManagerID.isInvalid],
            ["ProjectTemplateID", [fields.ProjectTemplateID.visible && fields.ProjectTemplateID.required ? ew.Validators.required(fields.ProjectTemplateID.caption) : null], fields.ProjectTemplateID.isInvalid],
            ["Priority", [fields.Priority.visible && fields.Priority.required ? ew.Validators.required(fields.Priority.caption) : null], fields.Priority.isInvalid],
            ["Description", [fields.Description.visible && fields.Description.required ? ew.Validators.required(fields.Description.caption) : null], fields.Description.isInvalid],
            ["ProjectValue", [fields.ProjectValue.visible && fields.ProjectValue.required ? ew.Validators.required(fields.ProjectValue.caption) : null, ew.Validators.float, ew.Validators.selected], fields.ProjectValue.isInvalid],
            ["ProjectDebt", [fields.ProjectDebt.visible && fields.ProjectDebt.required ? ew.Validators.required(fields.ProjectDebt.caption) : null, ew.Validators.float, ew.Validators.selected], fields.ProjectDebt.isInvalid],
            ["PONumber", [fields.PONumber.visible && fields.PONumber.required ? ew.Validators.required(fields.PONumber.caption) : null], fields.PONumber.isInvalid],
            ["PaymentLink", [fields.PaymentLink.visible && fields.PaymentLink.required ? ew.Validators.required(fields.PaymentLink.caption) : null], fields.PaymentLink.isInvalid],
            ["ClearingDate", [fields.ClearingDate.visible && fields.ClearingDate.required ? ew.Validators.required(fields.ClearingDate.caption) : null, ew.Validators.datetime(fields.ClearingDate.clientFormatPattern), ew.Validators.selected], fields.ClearingDate.isInvalid],
            ["ClearingAging", [fields.ClearingAging.visible && fields.ClearingAging.required ? ew.Validators.required(fields.ClearingAging.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.ClearingAging.isInvalid],
            ["Active", [fields.Active.visible && fields.Active.required ? ew.Validators.required(fields.Active.caption) : null], fields.Active.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Status": <?= $Page->Status->toClientList($Page) ?>,
            "ClientID": <?= $Page->ClientID->toClientList($Page) ?>,
            "ManagerID": <?= $Page->ManagerID->toClientList($Page) ?>,
            "ProjectTemplateID": <?= $Page->ProjectTemplateID->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasterprojectupdate" id="fmasterprojectupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masterproject">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_masterprojectupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->ProjectName->Visible && (!$Page->isConfirm() || $Page->ProjectName->multiUpdateSelected())) { // ProjectName ?>
    <div id="r_ProjectName"<?= $Page->ProjectName->rowAttributes() ?>>
        <label for="x_ProjectName" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ProjectName" id="u_ProjectName" class="form-check-input ew-multi-select" value="1"<?= $Page->ProjectName->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ProjectName"><?= $Page->ProjectName->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectName->cellAttributes() ?>>
                <span id="el_masterproject_ProjectName">
                <input type="<?= $Page->ProjectName->getInputTextType() ?>" name="x_ProjectName" id="x_ProjectName" data-table="masterproject" data-field="x_ProjectName" value="<?= $Page->ProjectName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ProjectName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectName->formatPattern()) ?>"<?= $Page->ProjectName->editAttributes() ?> aria-describedby="x_ProjectName_help">
                <?= $Page->ProjectName->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->ProjectName->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlanStart->Visible && (!$Page->isConfirm() || $Page->PlanStart->multiUpdateSelected())) { // PlanStart ?>
    <div id="r_PlanStart"<?= $Page->PlanStart->rowAttributes() ?>>
        <label for="x_PlanStart" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_PlanStart" id="u_PlanStart" class="form-check-input ew-multi-select" value="1"<?= $Page->PlanStart->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_PlanStart"><?= $Page->PlanStart->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlanStart->cellAttributes() ?>>
                <span id="el_masterproject_PlanStart">
                <input type="<?= $Page->PlanStart->getInputTextType() ?>" name="x_PlanStart" id="x_PlanStart" data-table="masterproject" data-field="x_PlanStart" value="<?= $Page->PlanStart->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanStart->formatPattern()) ?>"<?= $Page->PlanStart->editAttributes() ?> aria-describedby="x_PlanStart_help">
                <?= $Page->PlanStart->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage() ?></div>
                <?php if (!$Page->PlanStart->ReadOnly && !$Page->PlanStart->Disabled && !isset($Page->PlanStart->EditAttrs["readonly"]) && !isset($Page->PlanStart->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fmasterprojectupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(5) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fmasterprojectupdate", "x_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlanEnd->Visible && (!$Page->isConfirm() || $Page->PlanEnd->multiUpdateSelected())) { // PlanEnd ?>
    <div id="r_PlanEnd"<?= $Page->PlanEnd->rowAttributes() ?>>
        <label for="x_PlanEnd" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_PlanEnd" id="u_PlanEnd" class="form-check-input ew-multi-select" value="1"<?= $Page->PlanEnd->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_PlanEnd"><?= $Page->PlanEnd->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlanEnd->cellAttributes() ?>>
                <span id="el_masterproject_PlanEnd">
                <input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="x_PlanEnd" id="x_PlanEnd" data-table="masterproject" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?> aria-describedby="x_PlanEnd_help">
                <?= $Page->PlanEnd->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage() ?></div>
                <?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fmasterprojectupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(5) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fmasterprojectupdate", "x_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->StartDate->Visible && (!$Page->isConfirm() || $Page->StartDate->multiUpdateSelected())) { // StartDate ?>
    <div id="r_StartDate"<?= $Page->StartDate->rowAttributes() ?>>
        <label for="x_StartDate" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_StartDate" id="u_StartDate" class="form-check-input ew-multi-select" value="1"<?= $Page->StartDate->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_StartDate"><?= $Page->StartDate->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->StartDate->cellAttributes() ?>>
                <span id="el_masterproject_StartDate">
                <input type="<?= $Page->StartDate->getInputTextType() ?>" name="x_StartDate" id="x_StartDate" data-table="masterproject" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?> aria-describedby="x_StartDate_help">
                <?= $Page->StartDate->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage() ?></div>
                <?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fmasterprojectupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(5) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fmasterprojectupdate", "x_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->EndDate->Visible && (!$Page->isConfirm() || $Page->EndDate->multiUpdateSelected())) { // EndDate ?>
    <div id="r_EndDate"<?= $Page->EndDate->rowAttributes() ?>>
        <label for="x_EndDate" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_EndDate" id="u_EndDate" class="form-check-input ew-multi-select" value="1"<?= $Page->EndDate->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_EndDate"><?= $Page->EndDate->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EndDate->cellAttributes() ?>>
                <span id="el_masterproject_EndDate">
                <input type="<?= $Page->EndDate->getInputTextType() ?>" name="x_EndDate" id="x_EndDate" data-table="masterproject" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?> aria-describedby="x_EndDate_help">
                <?= $Page->EndDate->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage() ?></div>
                <?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fmasterprojectupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(5) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fmasterprojectupdate", "x_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->WarrantyEnd->Visible && (!$Page->isConfirm() || $Page->WarrantyEnd->multiUpdateSelected())) { // WarrantyEnd ?>
    <div id="r_WarrantyEnd"<?= $Page->WarrantyEnd->rowAttributes() ?>>
        <label for="x_WarrantyEnd" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_WarrantyEnd" id="u_WarrantyEnd" class="form-check-input ew-multi-select" value="1"<?= $Page->WarrantyEnd->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_WarrantyEnd"><?= $Page->WarrantyEnd->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->WarrantyEnd->cellAttributes() ?>>
                <span id="el_masterproject_WarrantyEnd">
                <input type="<?= $Page->WarrantyEnd->getInputTextType() ?>" name="x_WarrantyEnd" id="x_WarrantyEnd" data-table="masterproject" data-field="x_WarrantyEnd" value="<?= $Page->WarrantyEnd->EditValue ?>" placeholder="<?= HtmlEncode($Page->WarrantyEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WarrantyEnd->formatPattern()) ?>"<?= $Page->WarrantyEnd->editAttributes() ?> aria-describedby="x_WarrantyEnd_help">
                <?= $Page->WarrantyEnd->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->WarrantyEnd->getErrorMessage() ?></div>
                <?php if (!$Page->WarrantyEnd->ReadOnly && !$Page->WarrantyEnd->Disabled && !isset($Page->WarrantyEnd->EditAttrs["readonly"]) && !isset($Page->WarrantyEnd->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fmasterprojectupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(5) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fmasterprojectupdate", "x_WarrantyEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Status->Visible && (!$Page->isConfirm() || $Page->Status->multiUpdateSelected())) { // Status ?>
    <div id="r_Status"<?= $Page->Status->rowAttributes() ?>>
        <label for="x_Status" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Status" id="u_Status" class="form-check-input ew-multi-select" value="1"<?= $Page->Status->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Status"><?= $Page->Status->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Status->cellAttributes() ?>>
                <span id="el_masterproject_Status">
                    <select
                        id="x_Status"
                        name="x_Status"
                        class="form-select ew-select<?= $Page->Status->isInvalidClass() ?>"
                        <?php if (!$Page->Status->IsNativeSelect) { ?>
                        data-select2-id="fmasterprojectupdate_x_Status"
                        <?php } ?>
                        data-table="masterproject"
                        data-field="x_Status"
                        data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
                        <?= $Page->Status->editAttributes() ?>>
                        <?= $Page->Status->selectOptionListHtml("x_Status") ?>
                    </select>
                    <?= $Page->Status->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->Status->getErrorMessage() ?></div>
                <?= $Page->Status->Lookup->getParamTag($Page, "p_x_Status") ?>
                <?php if (!$Page->Status->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fmasterprojectupdate", function() {
                    var options = { name: "x_Status", selectId: "fmasterprojectupdate_x_Status" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fmasterprojectupdate.lists.Status?.lookupOptions.length) {
                        options.data = { id: "x_Status", form: "fmasterprojectupdate" };
                    } else {
                        options.ajax = { id: "x_Status", form: "fmasterprojectupdate", limit: 3 };
                    }
                    options.minimumInputLength = ew.selectMinimumInputLength;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.Status.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Target->Visible && (!$Page->isConfirm() || $Page->Target->multiUpdateSelected())) { // Target ?>
    <div id="r_Target"<?= $Page->Target->rowAttributes() ?>>
        <label for="x_Target" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Target" id="u_Target" class="form-check-input ew-multi-select" value="1"<?= $Page->Target->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Target"><?= $Page->Target->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Target->cellAttributes() ?>>
                <span id="el_masterproject_Target">
                <input type="<?= $Page->Target->getInputTextType() ?>" name="x_Target" id="x_Target" data-table="masterproject" data-field="x_Target" value="<?= $Page->Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Target->formatPattern()) ?>"<?= $Page->Target->editAttributes() ?> aria-describedby="x_Target_help">
                <?= $Page->Target->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->Target->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Track->Visible && (!$Page->isConfirm() || $Page->Track->multiUpdateSelected())) { // Track ?>
    <div id="r_Track"<?= $Page->Track->rowAttributes() ?>>
        <label for="x_Track" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Track" id="u_Track" class="form-check-input ew-multi-select" value="1"<?= $Page->Track->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Track"><?= $Page->Track->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Track->cellAttributes() ?>>
                <span id="el_masterproject_Track">
                <input type="<?= $Page->Track->getInputTextType() ?>" name="x_Track" id="x_Track" data-table="masterproject" data-field="x_Track" value="<?= $Page->Track->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->Track->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Track->formatPattern()) ?>"<?= $Page->Track->editAttributes() ?> aria-describedby="x_Track_help">
                <?= $Page->Track->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->Track->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AgingPayment->Visible && (!$Page->isConfirm() || $Page->AgingPayment->multiUpdateSelected())) { // AgingPayment ?>
    <div id="r_AgingPayment"<?= $Page->AgingPayment->rowAttributes() ?>>
        <label for="x_AgingPayment" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_AgingPayment" id="u_AgingPayment" class="form-check-input ew-multi-select" value="1"<?= $Page->AgingPayment->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_AgingPayment"><?= $Page->AgingPayment->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AgingPayment->cellAttributes() ?>>
                <span id="el_masterproject_AgingPayment">
                <input type="<?= $Page->AgingPayment->getInputTextType() ?>" name="x_AgingPayment" id="x_AgingPayment" data-table="masterproject" data-field="x_AgingPayment" value="<?= $Page->AgingPayment->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AgingPayment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgingPayment->formatPattern()) ?>"<?= $Page->AgingPayment->editAttributes() ?> aria-describedby="x_AgingPayment_help">
                <?= $Page->AgingPayment->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->AgingPayment->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ClientID->Visible && (!$Page->isConfirm() || $Page->ClientID->multiUpdateSelected())) { // ClientID ?>
    <div id="r_ClientID"<?= $Page->ClientID->rowAttributes() ?>>
        <label for="x_ClientID" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ClientID" id="u_ClientID" class="form-check-input ew-multi-select" value="1"<?= $Page->ClientID->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ClientID"><?= $Page->ClientID->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClientID->cellAttributes() ?>>
                <span id="el_masterproject_ClientID">
                    <select
                        id="x_ClientID"
                        name="x_ClientID"
                        class="form-select ew-select<?= $Page->ClientID->isInvalidClass() ?>"
                        <?php if (!$Page->ClientID->IsNativeSelect) { ?>
                        data-select2-id="fmasterprojectupdate_x_ClientID"
                        <?php } ?>
                        data-table="masterproject"
                        data-field="x_ClientID"
                        data-value-separator="<?= $Page->ClientID->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->ClientID->getPlaceHolder()) ?>"
                        <?= $Page->ClientID->editAttributes() ?>>
                        <?= $Page->ClientID->selectOptionListHtml("x_ClientID") ?>
                    </select>
                    <?= $Page->ClientID->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->ClientID->getErrorMessage() ?></div>
                <?= $Page->ClientID->Lookup->getParamTag($Page, "p_x_ClientID") ?>
                <?php if (!$Page->ClientID->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fmasterprojectupdate", function() {
                    var options = { name: "x_ClientID", selectId: "fmasterprojectupdate_x_ClientID" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fmasterprojectupdate.lists.ClientID?.lookupOptions.length) {
                        options.data = { id: "x_ClientID", form: "fmasterprojectupdate" };
                    } else {
                        options.ajax = { id: "x_ClientID", form: "fmasterprojectupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumInputLength = ew.selectMinimumInputLength;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ClientID.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ManagerID->Visible && (!$Page->isConfirm() || $Page->ManagerID->multiUpdateSelected())) { // ManagerID ?>
    <div id="r_ManagerID"<?= $Page->ManagerID->rowAttributes() ?>>
        <label for="x_ManagerID" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ManagerID" id="u_ManagerID" class="form-check-input ew-multi-select" value="1"<?= $Page->ManagerID->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ManagerID"><?= $Page->ManagerID->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ManagerID->cellAttributes() ?>>
                <span id="el_masterproject_ManagerID">
                    <select
                        id="x_ManagerID"
                        name="x_ManagerID"
                        class="form-select ew-select<?= $Page->ManagerID->isInvalidClass() ?>"
                        <?php if (!$Page->ManagerID->IsNativeSelect) { ?>
                        data-select2-id="fmasterprojectupdate_x_ManagerID"
                        <?php } ?>
                        data-table="masterproject"
                        data-field="x_ManagerID"
                        data-value-separator="<?= $Page->ManagerID->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->ManagerID->getPlaceHolder()) ?>"
                        <?= $Page->ManagerID->editAttributes() ?>>
                        <?= $Page->ManagerID->selectOptionListHtml("x_ManagerID") ?>
                    </select>
                    <?= $Page->ManagerID->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->ManagerID->getErrorMessage() ?></div>
                <?= $Page->ManagerID->Lookup->getParamTag($Page, "p_x_ManagerID") ?>
                <?php if (!$Page->ManagerID->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fmasterprojectupdate", function() {
                    var options = { name: "x_ManagerID", selectId: "fmasterprojectupdate_x_ManagerID" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fmasterprojectupdate.lists.ManagerID?.lookupOptions.length) {
                        options.data = { id: "x_ManagerID", form: "fmasterprojectupdate" };
                    } else {
                        options.ajax = { id: "x_ManagerID", form: "fmasterprojectupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumInputLength = ew.selectMinimumInputLength;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ManagerID.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectTemplateID->Visible && (!$Page->isConfirm() || $Page->ProjectTemplateID->multiUpdateSelected())) { // ProjectTemplateID ?>
    <div id="r_ProjectTemplateID"<?= $Page->ProjectTemplateID->rowAttributes() ?>>
        <label for="x_ProjectTemplateID" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ProjectTemplateID" id="u_ProjectTemplateID" class="form-check-input ew-multi-select" value="1"<?= $Page->ProjectTemplateID->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ProjectTemplateID"><?= $Page->ProjectTemplateID->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectTemplateID->cellAttributes() ?>>
                <span id="el_masterproject_ProjectTemplateID">
                    <select
                        id="x_ProjectTemplateID"
                        name="x_ProjectTemplateID"
                        class="form-select ew-select<?= $Page->ProjectTemplateID->isInvalidClass() ?>"
                        <?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
                        data-select2-id="fmasterprojectupdate_x_ProjectTemplateID"
                        <?php } ?>
                        data-table="masterproject"
                        data-field="x_ProjectTemplateID"
                        data-value-separator="<?= $Page->ProjectTemplateID->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->ProjectTemplateID->getPlaceHolder()) ?>"
                        <?= $Page->ProjectTemplateID->editAttributes() ?>>
                        <?= $Page->ProjectTemplateID->selectOptionListHtml("x_ProjectTemplateID") ?>
                    </select>
                    <?= $Page->ProjectTemplateID->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->ProjectTemplateID->getErrorMessage() ?></div>
                <?= $Page->ProjectTemplateID->Lookup->getParamTag($Page, "p_x_ProjectTemplateID") ?>
                <?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fmasterprojectupdate", function() {
                    var options = { name: "x_ProjectTemplateID", selectId: "fmasterprojectupdate_x_ProjectTemplateID" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fmasterprojectupdate.lists.ProjectTemplateID?.lookupOptions.length) {
                        options.data = { id: "x_ProjectTemplateID", form: "fmasterprojectupdate" };
                    } else {
                        options.ajax = { id: "x_ProjectTemplateID", form: "fmasterprojectupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumInputLength = ew.selectMinimumInputLength;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ProjectTemplateID.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Priority->Visible && (!$Page->isConfirm() || $Page->Priority->multiUpdateSelected())) { // Priority ?>
    <div id="r_Priority"<?= $Page->Priority->rowAttributes() ?>>
        <label for="x_Priority" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Priority" id="u_Priority" class="form-check-input ew-multi-select" value="1"<?= $Page->Priority->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Priority"><?= $Page->Priority->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Priority->cellAttributes() ?>>
                <span id="el_masterproject_Priority">
                    <select
                        id="x_Priority"
                        name="x_Priority"
                        class="form-select ew-select<?= $Page->Priority->isInvalidClass() ?>"
                        <?php if (!$Page->Priority->IsNativeSelect) { ?>
                        data-select2-id="fmasterprojectupdate_x_Priority"
                        <?php } ?>
                        data-table="masterproject"
                        data-field="x_Priority"
                        data-value-separator="<?= $Page->Priority->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->Priority->getPlaceHolder()) ?>"
                        <?= $Page->Priority->editAttributes() ?>>
                        <?= $Page->Priority->selectOptionListHtml("x_Priority") ?>
                    </select>
                    <?= $Page->Priority->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->Priority->getErrorMessage() ?></div>
                <?php if (!$Page->Priority->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fmasterprojectupdate", function() {
                    var options = { name: "x_Priority", selectId: "fmasterprojectupdate_x_Priority" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fmasterprojectupdate.lists.Priority?.lookupOptions.length) {
                        options.data = { id: "x_Priority", form: "fmasterprojectupdate" };
                    } else {
                        options.ajax = { id: "x_Priority", form: "fmasterprojectupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.Priority.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Description->Visible && (!$Page->isConfirm() || $Page->Description->multiUpdateSelected())) { // Description ?>
    <div id="r_Description"<?= $Page->Description->rowAttributes() ?>>
        <label for="x_Description" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Description" id="u_Description" class="form-check-input ew-multi-select" value="1"<?= $Page->Description->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Description"><?= $Page->Description->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Description->cellAttributes() ?>>
                <span id="el_masterproject_Description">
                <textarea data-table="masterproject" data-field="x_Description" name="x_Description" id="x_Description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->Description->getPlaceHolder()) ?>"<?= $Page->Description->editAttributes() ?> aria-describedby="x_Description_help"><?= $Page->Description->EditValue ?></textarea>
                <?= $Page->Description->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->Description->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectValue->Visible && (!$Page->isConfirm() || $Page->ProjectValue->multiUpdateSelected())) { // ProjectValue ?>
    <div id="r_ProjectValue"<?= $Page->ProjectValue->rowAttributes() ?>>
        <label for="x_ProjectValue" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ProjectValue" id="u_ProjectValue" class="form-check-input ew-multi-select" value="1"<?= $Page->ProjectValue->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ProjectValue"><?= $Page->ProjectValue->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectValue->cellAttributes() ?>>
                <span id="el_masterproject_ProjectValue">
                <input type="<?= $Page->ProjectValue->getInputTextType() ?>" name="x_ProjectValue" id="x_ProjectValue" data-table="masterproject" data-field="x_ProjectValue" value="<?= $Page->ProjectValue->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectValue->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectValue->formatPattern()) ?>"<?= $Page->ProjectValue->editAttributes() ?> aria-describedby="x_ProjectValue_help">
                <?= $Page->ProjectValue->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->ProjectValue->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectDebt->Visible && (!$Page->isConfirm() || $Page->ProjectDebt->multiUpdateSelected())) { // ProjectDebt ?>
    <div id="r_ProjectDebt"<?= $Page->ProjectDebt->rowAttributes() ?>>
        <label for="x_ProjectDebt" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ProjectDebt" id="u_ProjectDebt" class="form-check-input ew-multi-select" value="1"<?= $Page->ProjectDebt->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ProjectDebt"><?= $Page->ProjectDebt->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectDebt->cellAttributes() ?>>
                <span id="el_masterproject_ProjectDebt">
                <input type="<?= $Page->ProjectDebt->getInputTextType() ?>" name="x_ProjectDebt" id="x_ProjectDebt" data-table="masterproject" data-field="x_ProjectDebt" value="<?= $Page->ProjectDebt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectDebt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectDebt->formatPattern()) ?>"<?= $Page->ProjectDebt->editAttributes() ?> aria-describedby="x_ProjectDebt_help">
                <?= $Page->ProjectDebt->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->ProjectDebt->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PONumber->Visible && (!$Page->isConfirm() || $Page->PONumber->multiUpdateSelected())) { // PONumber ?>
    <div id="r_PONumber"<?= $Page->PONumber->rowAttributes() ?>>
        <label for="x_PONumber" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_PONumber" id="u_PONumber" class="form-check-input ew-multi-select" value="1"<?= $Page->PONumber->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_PONumber"><?= $Page->PONumber->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PONumber->cellAttributes() ?>>
                <span id="el_masterproject_PONumber">
                <input type="<?= $Page->PONumber->getInputTextType() ?>" name="x_PONumber" id="x_PONumber" data-table="masterproject" data-field="x_PONumber" value="<?= $Page->PONumber->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->PONumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PONumber->formatPattern()) ?>"<?= $Page->PONumber->editAttributes() ?> aria-describedby="x_PONumber_help">
                <?= $Page->PONumber->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->PONumber->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PaymentLink->Visible && (!$Page->isConfirm() || $Page->PaymentLink->multiUpdateSelected())) { // PaymentLink ?>
    <div id="r_PaymentLink"<?= $Page->PaymentLink->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_PaymentLink" id="u_PaymentLink" class="form-check-input ew-multi-select" value="1"<?= $Page->PaymentLink->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_PaymentLink"><?= $Page->PaymentLink->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PaymentLink->cellAttributes() ?>>
                <span id="el_masterproject_PaymentLink">
                <?php $Page->PaymentLink->EditAttrs->appendClass("editor"); ?>
                <textarea data-table="masterproject" data-field="x_PaymentLink" name="x_PaymentLink" id="x_PaymentLink" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->PaymentLink->getPlaceHolder()) ?>"<?= $Page->PaymentLink->editAttributes() ?> aria-describedby="x_PaymentLink_help"><?= $Page->PaymentLink->EditValue ?></textarea>
                <?= $Page->PaymentLink->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->PaymentLink->getErrorMessage() ?></div>
                <script>
                loadjs.ready(["fmasterprojectupdate", "editor"], function() {
                    ew.createEditor("fmasterprojectupdate", "x_PaymentLink", 0, 0, <?= $Page->PaymentLink->ReadOnly || false ? "true" : "false" ?>);
                });
                </script>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ClearingDate->Visible && (!$Page->isConfirm() || $Page->ClearingDate->multiUpdateSelected())) { // ClearingDate ?>
    <div id="r_ClearingDate"<?= $Page->ClearingDate->rowAttributes() ?>>
        <label for="x_ClearingDate" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ClearingDate" id="u_ClearingDate" class="form-check-input ew-multi-select" value="1"<?= $Page->ClearingDate->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ClearingDate"><?= $Page->ClearingDate->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClearingDate->cellAttributes() ?>>
                <span id="el_masterproject_ClearingDate">
                <input type="<?= $Page->ClearingDate->getInputTextType() ?>" name="x_ClearingDate" id="x_ClearingDate" data-table="masterproject" data-field="x_ClearingDate" value="<?= $Page->ClearingDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ClearingDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearingDate->formatPattern()) ?>"<?= $Page->ClearingDate->editAttributes() ?> aria-describedby="x_ClearingDate_help">
                <?= $Page->ClearingDate->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->ClearingDate->getErrorMessage() ?></div>
                <?php if (!$Page->ClearingDate->ReadOnly && !$Page->ClearingDate->Disabled && !isset($Page->ClearingDate->EditAttrs["readonly"]) && !isset($Page->ClearingDate->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fmasterprojectupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(5) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fmasterprojectupdate", "x_ClearingDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ClearingAging->Visible && (!$Page->isConfirm() || $Page->ClearingAging->multiUpdateSelected())) { // ClearingAging ?>
    <div id="r_ClearingAging"<?= $Page->ClearingAging->rowAttributes() ?>>
        <label for="x_ClearingAging" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ClearingAging" id="u_ClearingAging" class="form-check-input ew-multi-select" value="1"<?= $Page->ClearingAging->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ClearingAging"><?= $Page->ClearingAging->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClearingAging->cellAttributes() ?>>
                <span id="el_masterproject_ClearingAging">
                <input type="<?= $Page->ClearingAging->getInputTextType() ?>" name="x_ClearingAging" id="x_ClearingAging" data-table="masterproject" data-field="x_ClearingAging" value="<?= $Page->ClearingAging->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ClearingAging->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearingAging->formatPattern()) ?>"<?= $Page->ClearingAging->editAttributes() ?> aria-describedby="x_ClearingAging_help">
                <?= $Page->ClearingAging->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->ClearingAging->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible && (!$Page->isConfirm() || $Page->Active->multiUpdateSelected())) { // Active ?>
    <div id="r_Active"<?= $Page->Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Active" id="u_Active" class="form-check-input ew-multi-select" value="1"<?= $Page->Active->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Active"><?= $Page->Active->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Active->cellAttributes() ?>>
                <span id="el_masterproject_Active">
                <div class="form-check d-inline-block">
                    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masterproject" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->CurrentValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?> aria-describedby="x_Active_help">
                    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage() ?></div>
                </div>
                <?= $Page->Active->getCustomMessage() ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmasterprojectupdate"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasterprojectupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masterproject");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
