<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasteruserAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masteruser: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmasteruseradd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmasteruseradd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["FirstName", [fields.FirstName.visible && fields.FirstName.required ? ew.Validators.required(fields.FirstName.caption) : null], fields.FirstName.isInvalid],
            ["LastName", [fields.LastName.visible && fields.LastName.required ? ew.Validators.required(fields.LastName.caption) : null], fields.LastName.isInvalid],
            ["_Username", [fields._Username.visible && fields._Username.required ? ew.Validators.required(fields._Username.caption) : null], fields._Username.isInvalid],
            ["UserPassword", [fields.UserPassword.visible && fields.UserPassword.required ? ew.Validators.required(fields.UserPassword.caption) : null], fields.UserPassword.isInvalid],
            ["Level", [fields.Level.visible && fields.Level.required ? ew.Validators.required(fields.Level.caption) : null], fields.Level.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null], fields._Email.isInvalid],
            ["Position", [fields.Position.visible && fields.Position.required ? ew.Validators.required(fields.Position.caption) : null], fields.Position.isInvalid],
            ["Department", [fields.Department.visible && fields.Department.required ? ew.Validators.required(fields.Department.caption) : null], fields.Department.isInvalid],
            ["Employee", [fields.Employee.visible && fields.Employee.required ? ew.Validators.required(fields.Employee.caption) : null], fields.Employee.isInvalid],
            ["WhatsAppNumber", [fields.WhatsAppNumber.visible && fields.WhatsAppNumber.required ? ew.Validators.required(fields.WhatsAppNumber.caption) : null], fields.WhatsAppNumber.isInvalid],
            ["Active", [fields.Active.visible && fields.Active.required ? ew.Validators.required(fields.Active.caption) : null], fields.Active.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Level": <?= $Page->Level->toClientList($Page) ?>,
            "Position": <?= $Page->Position->toClientList($Page) ?>,
            "Employee": <?= $Page->Employee->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasteruseradd" id="fmasteruseradd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masteruser">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->FirstName->Visible) { // FirstName ?>
    <div id="r_FirstName"<?= $Page->FirstName->rowAttributes() ?>>
        <label id="elh_masteruser_FirstName" for="x_FirstName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FirstName->caption() ?><?= $Page->FirstName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FirstName->cellAttributes() ?>>
<span id="el_masteruser_FirstName">
<input type="<?= $Page->FirstName->getInputTextType() ?>" name="x_FirstName" id="x_FirstName" data-table="masteruser" data-field="x_FirstName" value="<?= $Page->FirstName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FirstName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FirstName->formatPattern()) ?>"<?= $Page->FirstName->editAttributes() ?> aria-describedby="x_FirstName_help">
<?= $Page->FirstName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FirstName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->LastName->Visible) { // LastName ?>
    <div id="r_LastName"<?= $Page->LastName->rowAttributes() ?>>
        <label id="elh_masteruser_LastName" for="x_LastName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->LastName->caption() ?><?= $Page->LastName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->LastName->cellAttributes() ?>>
<span id="el_masteruser_LastName">
<input type="<?= $Page->LastName->getInputTextType() ?>" name="x_LastName" id="x_LastName" data-table="masteruser" data-field="x_LastName" value="<?= $Page->LastName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->LastName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LastName->formatPattern()) ?>"<?= $Page->LastName->editAttributes() ?> aria-describedby="x_LastName_help">
<?= $Page->LastName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->LastName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Username->Visible) { // Username ?>
    <div id="r__Username"<?= $Page->_Username->rowAttributes() ?>>
        <label id="elh_masteruser__Username" for="x__Username" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Username->caption() ?><?= $Page->_Username->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Username->cellAttributes() ?>>
<span id="el_masteruser__Username">
<input type="<?= $Page->_Username->getInputTextType() ?>" name="x__Username" id="x__Username" data-table="masteruser" data-field="x__Username" value="<?= $Page->_Username->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Username->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Username->formatPattern()) ?>"<?= $Page->_Username->editAttributes() ?> aria-describedby="x__Username_help">
<?= $Page->_Username->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Username->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->UserPassword->Visible) { // UserPassword ?>
    <div id="r_UserPassword"<?= $Page->UserPassword->rowAttributes() ?>>
        <label id="elh_masteruser_UserPassword" for="x_UserPassword" class="<?= $Page->LeftColumnClass ?>"><?= $Page->UserPassword->caption() ?><?= $Page->UserPassword->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->UserPassword->cellAttributes() ?>>
<span id="el_masteruser_UserPassword">
<div class="input-group">
    <input type="password" name="x_UserPassword" id="x_UserPassword" autocomplete="new-password" data-field="x_UserPassword" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->UserPassword->getPlaceHolder()) ?>"<?= $Page->UserPassword->editAttributes() ?> aria-describedby="x_UserPassword_help">
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
</div>
<?= $Page->UserPassword->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->UserPassword->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Level->Visible) { // Level ?>
    <div id="r_Level"<?= $Page->Level->rowAttributes() ?>>
        <label id="elh_masteruser_Level" for="x_Level" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Level->caption() ?><?= $Page->Level->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Level->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<span id="el_masteruser_Level">
<span class="form-control-plaintext"><?= $Page->Level->getDisplayValue($Page->Level->EditValue) ?></span>
</span>
<?php } else { ?>
<span id="el_masteruser_Level">
    <select
        id="x_Level"
        name="x_Level"
        class="form-select ew-select<?= $Page->Level->isInvalidClass() ?>"
        <?php if (!$Page->Level->IsNativeSelect) { ?>
        data-select2-id="fmasteruseradd_x_Level"
        <?php } ?>
        data-table="masteruser"
        data-field="x_Level"
        data-value-separator="<?= $Page->Level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Level->getPlaceHolder()) ?>"
        <?= $Page->Level->editAttributes() ?>>
        <?= $Page->Level->selectOptionListHtml("x_Level") ?>
    </select>
    <?= $Page->Level->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Level->getErrorMessage() ?></div>
<?= $Page->Level->Lookup->getParamTag($Page, "p_x_Level") ?>
<?php if (!$Page->Level->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasteruseradd", function() {
    var options = { name: "x_Level", selectId: "fmasteruseradd_x_Level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasteruseradd.lists.Level?.lookupOptions.length) {
        options.data = { id: "x_Level", form: "fmasteruseradd" };
    } else {
        options.ajax = { id: "x_Level", form: "fmasteruseradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masteruser.fields.Level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_masteruser__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<span id="el_masteruser__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="masteruser" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Position->Visible) { // Position ?>
    <div id="r_Position"<?= $Page->Position->rowAttributes() ?>>
        <label id="elh_masteruser_Position" for="x_Position" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Position->caption() ?><?= $Page->Position->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Position->cellAttributes() ?>>
<span id="el_masteruser_Position">
    <select
        id="x_Position"
        name="x_Position"
        class="form-select ew-select<?= $Page->Position->isInvalidClass() ?>"
        <?php if (!$Page->Position->IsNativeSelect) { ?>
        data-select2-id="fmasteruseradd_x_Position"
        <?php } ?>
        data-table="masteruser"
        data-field="x_Position"
        data-value-separator="<?= $Page->Position->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>"
        <?= $Page->Position->editAttributes() ?>>
        <?= $Page->Position->selectOptionListHtml("x_Position") ?>
    </select>
    <?= $Page->Position->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Position->getErrorMessage() ?></div>
<?php if (!$Page->Position->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasteruseradd", function() {
    var options = { name: "x_Position", selectId: "fmasteruseradd_x_Position" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasteruseradd.lists.Position?.lookupOptions.length) {
        options.data = { id: "x_Position", form: "fmasteruseradd" };
    } else {
        options.ajax = { id: "x_Position", form: "fmasteruseradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masteruser.fields.Position.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Department->Visible) { // Department ?>
    <div id="r_Department"<?= $Page->Department->rowAttributes() ?>>
        <label id="elh_masteruser_Department" for="x_Department" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Department->caption() ?><?= $Page->Department->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Department->cellAttributes() ?>>
<span id="el_masteruser_Department">
<input type="<?= $Page->Department->getInputTextType() ?>" name="x_Department" id="x_Department" data-table="masteruser" data-field="x_Department" value="<?= $Page->Department->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Department->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Department->formatPattern()) ?>"<?= $Page->Department->editAttributes() ?> aria-describedby="x_Department_help">
<?= $Page->Department->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Department->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Employee->Visible) { // Employee ?>
    <div id="r_Employee"<?= $Page->Employee->rowAttributes() ?>>
        <label id="elh_masteruser_Employee" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Employee->caption() ?><?= $Page->Employee->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Employee->cellAttributes() ?>>
<span id="el_masteruser_Employee">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Employee->isInvalidClass() ?>" data-table="masteruser" data-field="x_Employee" data-boolean name="x_Employee" id="x_Employee" value="1"<?= ConvertToBool($Page->Employee->CurrentValue) ? " checked" : "" ?><?= $Page->Employee->editAttributes() ?> aria-describedby="x_Employee_help">
    <div class="invalid-feedback"><?= $Page->Employee->getErrorMessage() ?></div>
</div>
<?= $Page->Employee->getCustomMessage() ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->WhatsAppNumber->Visible) { // WhatsAppNumber ?>
    <div id="r_WhatsAppNumber"<?= $Page->WhatsAppNumber->rowAttributes() ?>>
        <label id="elh_masteruser_WhatsAppNumber" for="x_WhatsAppNumber" class="<?= $Page->LeftColumnClass ?>"><?= $Page->WhatsAppNumber->caption() ?><?= $Page->WhatsAppNumber->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->WhatsAppNumber->cellAttributes() ?>>
<span id="el_masteruser_WhatsAppNumber">
<input type="<?= $Page->WhatsAppNumber->getInputTextType() ?>" name="x_WhatsAppNumber" id="x_WhatsAppNumber" data-table="masteruser" data-field="x_WhatsAppNumber" value="<?= $Page->WhatsAppNumber->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->WhatsAppNumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WhatsAppNumber->formatPattern()) ?>"<?= $Page->WhatsAppNumber->editAttributes() ?> aria-describedby="x_WhatsAppNumber_help">
<?= $Page->WhatsAppNumber->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->WhatsAppNumber->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
    <div id="r_Active"<?= $Page->Active->rowAttributes() ?>>
        <label id="elh_masteruser_Active" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Active->caption() ?><?= $Page->Active->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Active->cellAttributes() ?>>
<span id="el_masteruser_Active">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masteruser" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->CurrentValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?> aria-describedby="x_Active_help">
    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage() ?></div>
</div>
<?= $Page->Active->getCustomMessage() ?>
</span>
</div></div>
    </div>
<?php } ?>
    <span id="el_masteruser_Created_Date">
    <input type="hidden" data-table="masteruser" data-field="x_Created_Date" data-hidden="1" name="x_Created_Date" id="x_Created_Date" value="<?= HtmlEncode($Page->Created_Date->CurrentValue) ?>">
    </span>
    <span id="el_masteruser_Created_By">
    <input type="hidden" data-table="masteruser" data-field="x_Created_By" data-hidden="1" name="x_Created_By" id="x_Created_By" value="<?= HtmlEncode($Page->Created_By->CurrentValue) ?>">
    </span>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmasteruseradd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasteruseradd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masteruser");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
