<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasteruserSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masteruser: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmasterusersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmasterusersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["EmployeeID", [ew.Validators.integer], fields.EmployeeID.isInvalid],
            ["FirstName", [], fields.FirstName.isInvalid],
            ["LastName", [], fields.LastName.isInvalid],
            ["FullName", [], fields.FullName.isInvalid],
            ["_Username", [], fields._Username.isInvalid],
            ["UserPassword", [], fields.UserPassword.isInvalid],
            ["Level", [], fields.Level.isInvalid],
            ["_Email", [], fields._Email.isInvalid],
            ["Position", [], fields.Position.isInvalid],
            ["Department", [], fields.Department.isInvalid],
            ["Employee", [], fields.Employee.isInvalid],
            ["WhatsAppNumber", [], fields.WhatsAppNumber.isInvalid],
            ["Active", [], fields.Active.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "Level": <?= $Page->Level->toClientList($Page) ?>,
            "Position": <?= $Page->Position->toClientList($Page) ?>,
            "Employee": <?= $Page->Employee->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasterusersearch" id="fmasterusersearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("masteruserlist")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masteruser">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_masteruser_EmployeeID" class="masterusersearch"><span id="el_masteruser_EmployeeID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->EmployeeID->getInputTextType() ?>" name="x_EmployeeID" id="x_EmployeeID" data-table="masteruser" data-field="x_EmployeeID" value="<?= $Page->EmployeeID->EditValue ?>" placeholder="<?= HtmlEncode($Page->EmployeeID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EmployeeID->formatPattern()) ?>"<?= $Page->EmployeeID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EmployeeID->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_FirstName" class="masterusersearch"><span id="el_masteruser_FirstName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FirstName->getInputTextType() ?>" name="x_FirstName" id="x_FirstName" data-table="masteruser" data-field="x_FirstName" value="<?= $Page->FirstName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FirstName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FirstName->formatPattern()) ?>"<?= $Page->FirstName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FirstName->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_LastName" class="masterusersearch"><span id="el_masteruser_LastName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->LastName->getInputTextType() ?>" name="x_LastName" id="x_LastName" data-table="masteruser" data-field="x_LastName" value="<?= $Page->LastName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->LastName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LastName->formatPattern()) ?>"<?= $Page->LastName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->LastName->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_FullName" class="masterusersearch"><span id="el_masteruser_FullName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FullName->getInputTextType() ?>" name="x_FullName" id="x_FullName" data-table="masteruser" data-field="x_FullName" value="<?= $Page->FullName->EditValue ?>" size="30" maxlength="201" placeholder="<?= HtmlEncode($Page->FullName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FullName->formatPattern()) ?>"<?= $Page->FullName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FullName->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser__Username" class="masterusersearch"><span id="el_masteruser__Username" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Username->getInputTextType() ?>" name="x__Username" id="x__Username" data-table="masteruser" data-field="x__Username" value="<?= $Page->_Username->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Username->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Username->formatPattern()) ?>"<?= $Page->_Username->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Username->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_UserPassword" class="masterusersearch"><span id="el_masteruser_UserPassword" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->UserPassword->getInputTextType() ?>" name="x_UserPassword" id="x_UserPassword" data-table="masteruser" data-field="x_UserPassword" value="<?= $Page->UserPassword->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->UserPassword->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->UserPassword->formatPattern()) ?>"<?= $Page->UserPassword->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->UserPassword->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_Level" class="masterusersearch"><span id="el_masteruser_Level" class="ew-search-field ew-search-field-single">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<span class="form-control-plaintext"><?= $Page->Level->getDisplayValue($Page->Level->EditValue) ?></span>
<?php } else { ?>
    <select
        id="x_Level"
        name="x_Level"
        class="form-select ew-select<?= $Page->Level->isInvalidClass() ?>"
        <?php if (!$Page->Level->IsNativeSelect) { ?>
        data-select2-id="fmasterusersearch_x_Level"
        <?php } ?>
        data-table="masteruser"
        data-field="x_Level"
        data-value-separator="<?= $Page->Level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Level->getPlaceHolder()) ?>"
        <?= $Page->Level->editAttributes() ?>>
        <?= $Page->Level->selectOptionListHtml("x_Level") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Level->getErrorMessage(false) ?></div>
<?= $Page->Level->Lookup->getParamTag($Page, "p_x_Level") ?>
<?php if (!$Page->Level->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterusersearch", function() {
    var options = { name: "x_Level", selectId: "fmasterusersearch_x_Level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterusersearch.lists.Level?.lookupOptions.length) {
        options.data = { id: "x_Level", form: "fmasterusersearch" };
    } else {
        options.ajax = { id: "x_Level", form: "fmasterusersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masteruser.fields.Level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
<?php } ?>
</span></template>
<template id="tpx_masteruser__Email" class="masterusersearch"><span id="el_masteruser__Email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="masteruser" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_Position" class="masterusersearch"><span id="el_masteruser_Position" class="ew-search-field ew-search-field-single">
    <select
        id="x_Position"
        name="x_Position"
        class="form-select ew-select<?= $Page->Position->isInvalidClass() ?>"
        <?php if (!$Page->Position->IsNativeSelect) { ?>
        data-select2-id="fmasterusersearch_x_Position"
        <?php } ?>
        data-table="masteruser"
        data-field="x_Position"
        data-value-separator="<?= $Page->Position->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>"
        <?= $Page->Position->editAttributes() ?>>
        <?= $Page->Position->selectOptionListHtml("x_Position") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Position->getErrorMessage(false) ?></div>
<?php if (!$Page->Position->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterusersearch", function() {
    var options = { name: "x_Position", selectId: "fmasterusersearch_x_Position" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterusersearch.lists.Position?.lookupOptions.length) {
        options.data = { id: "x_Position", form: "fmasterusersearch" };
    } else {
        options.ajax = { id: "x_Position", form: "fmasterusersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masteruser.fields.Position.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masteruser_Department" class="masterusersearch"><span id="el_masteruser_Department" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Department->getInputTextType() ?>" name="x_Department" id="x_Department" data-table="masteruser" data-field="x_Department" value="<?= $Page->Department->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Department->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Department->formatPattern()) ?>"<?= $Page->Department->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Department->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_Employee" class="masterusersearch"><span id="el_masteruser_Employee" class="ew-search-field ew-search-field-single">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Employee->isInvalidClass() ?>" data-table="masteruser" data-field="x_Employee" data-boolean name="x_Employee" id="x_Employee" value="1"<?= ConvertToBool($Page->Employee->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Employee->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Employee->getErrorMessage(false) ?></div>
</div>
</span></template>
<template id="tpx_masteruser_WhatsAppNumber" class="masterusersearch"><span id="el_masteruser_WhatsAppNumber" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->WhatsAppNumber->getInputTextType() ?>" name="x_WhatsAppNumber" id="x_WhatsAppNumber" data-table="masteruser" data-field="x_WhatsAppNumber" value="<?= $Page->WhatsAppNumber->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->WhatsAppNumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WhatsAppNumber->formatPattern()) ?>"<?= $Page->WhatsAppNumber->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WhatsAppNumber->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_Active" class="masterusersearch"><span id="el_masteruser_Active" class="ew-search-field ew-search-field-single">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masteruser" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
</div>
</span></template>
<template id="tpx_masteruser_Created_Date" class="masterusersearch"><span id="el_masteruser_Created_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="masteruser" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterusersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterusersearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masteruser_Created_By" class="masterusersearch"><span id="el_masteruser_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="masteruser" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masteruser_Last_Updated_Date" class="masterusersearch"><span id="el_masteruser_Last_Updated_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="masteruser" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterusersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterusersearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masteruser_Last_Updated_By" class="masterusersearch"><span id="el_masteruser_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="masteruser" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span></template>
<div id="masteruser_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "EmployeeID",
                type: "integer",
                label: currentTable.fields.EmployeeID.caption,
                operators: currentTable.fields.EmployeeID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.EmployeeID.validators),
                data: {
                    format: currentTable.fields.EmployeeID.clientFormatPattern
                }
            },
            {
                id: "FirstName",
                type: "string",
                label: currentTable.fields.FirstName.caption,
                operators: currentTable.fields.FirstName.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.FirstName.validators),
                data: {
                    format: currentTable.fields.FirstName.clientFormatPattern
                }
            },
            {
                id: "LastName",
                type: "string",
                label: currentTable.fields.LastName.caption,
                operators: currentTable.fields.LastName.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.LastName.validators),
                data: {
                    format: currentTable.fields.LastName.clientFormatPattern
                }
            },
            {
                id: "FullName",
                type: "string",
                label: currentTable.fields.FullName.caption,
                operators: currentTable.fields.FullName.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.FullName.validators),
                data: {
                    format: currentTable.fields.FullName.clientFormatPattern
                }
            },
            {
                id: "_Username",
                type: "string",
                label: currentTable.fields._Username.caption,
                operators: currentTable.fields._Username.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields._Username.validators),
                data: {
                    format: currentTable.fields._Username.clientFormatPattern
                }
            },
            {
                id: "UserPassword",
                type: "string",
                label: currentTable.fields.UserPassword.caption,
                operators: currentTable.fields.UserPassword.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.UserPassword.validators),
                data: {
                    format: currentTable.fields.UserPassword.clientFormatPattern
                }
            },
            {
                id: "Level",
                type: "integer",
                label: currentTable.fields.Level.caption,
                operators: currentTable.fields.Level.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Level.validators),
                data: {
                    format: currentTable.fields.Level.clientFormatPattern
                }
            },
            {
                id: "_Email",
                type: "string",
                label: currentTable.fields._Email.caption,
                operators: currentTable.fields._Email.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields._Email.validators),
                data: {
                    format: currentTable.fields._Email.clientFormatPattern
                }
            },
            {
                id: "Position",
                type: "string",
                label: currentTable.fields.Position.caption,
                operators: currentTable.fields.Position.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Position.validators),
                data: {
                    format: currentTable.fields.Position.clientFormatPattern
                }
            },
            {
                id: "Department",
                type: "string",
                label: currentTable.fields.Department.caption,
                operators: currentTable.fields.Department.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Department.validators),
                data: {
                    format: currentTable.fields.Department.clientFormatPattern
                }
            },
            {
                id: "Employee",
                type: "boolean",
                label: currentTable.fields.Employee.caption,
                operators: currentTable.fields.Employee.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Employee.validators),
                data: {
                    format: currentTable.fields.Employee.clientFormatPattern
                }
            },
            {
                id: "WhatsAppNumber",
                type: "string",
                label: currentTable.fields.WhatsAppNumber.caption,
                operators: currentTable.fields.WhatsAppNumber.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.WhatsAppNumber.validators),
                data: {
                    format: currentTable.fields.WhatsAppNumber.clientFormatPattern
                }
            },
            {
                id: "Active",
                type: "boolean",
                label: currentTable.fields.Active.caption,
                operators: currentTable.fields.Active.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Active.validators),
                data: {
                    format: currentTable.fields.Active.clientFormatPattern
                }
            },
            {
                id: "Created_Date",
                type: "datetime",
                label: currentTable.fields.Created_Date.caption,
                operators: currentTable.fields.Created_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Created_Date.validators),
                data: {
                    format: currentTable.fields.Created_Date.clientFormatPattern
                }
            },
            {
                id: "Created_By",
                type: "string",
                label: currentTable.fields.Created_By.caption,
                operators: currentTable.fields.Created_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Created_By.validators),
                data: {
                    format: currentTable.fields.Created_By.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_Date",
                type: "datetime",
                label: currentTable.fields.Last_Updated_Date.caption,
                operators: currentTable.fields.Last_Updated_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Last_Updated_Date.validators),
                data: {
                    format: currentTable.fields.Last_Updated_Date.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_By",
                type: "string",
                label: currentTable.fields.Last_Updated_By.caption,
                operators: currentTable.fields.Last_Updated_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterusersearch.fields.Last_Updated_By.validators),
                data: {
                    format: currentTable.fields.Last_Updated_By.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#masteruser_query_builder"),
        args = {},
        rules = ew.parseJson($("#fmasterusersearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fmasterusersearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fmasterusersearch" formaction="<?= HtmlEncode(GetUrl("masteruserlist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasterusersearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fmasterusersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masteruser");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
