<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasteruserUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masteruser: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fmasteruserupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmasteruserupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["FirstName", [fields.FirstName.visible && fields.FirstName.required ? ew.Validators.required(fields.FirstName.caption) : null], fields.FirstName.isInvalid],
            ["LastName", [fields.LastName.visible && fields.LastName.required ? ew.Validators.required(fields.LastName.caption) : null], fields.LastName.isInvalid],
            ["_Username", [fields._Username.visible && fields._Username.required ? ew.Validators.required(fields._Username.caption) : null], fields._Username.isInvalid],
            ["UserPassword", [fields.UserPassword.visible && fields.UserPassword.required ? ew.Validators.required(fields.UserPassword.caption) : null], fields.UserPassword.isInvalid],
            ["Level", [fields.Level.visible && fields.Level.required ? ew.Validators.required(fields.Level.caption) : null], fields.Level.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null], fields._Email.isInvalid],
            ["Position", [fields.Position.visible && fields.Position.required ? ew.Validators.required(fields.Position.caption) : null], fields.Position.isInvalid],
            ["Department", [fields.Department.visible && fields.Department.required ? ew.Validators.required(fields.Department.caption) : null], fields.Department.isInvalid],
            ["Employee", [fields.Employee.visible && fields.Employee.required ? ew.Validators.required(fields.Employee.caption) : null], fields.Employee.isInvalid],
            ["WhatsAppNumber", [fields.WhatsAppNumber.visible && fields.WhatsAppNumber.required ? ew.Validators.required(fields.WhatsAppNumber.caption) : null], fields.WhatsAppNumber.isInvalid],
            ["Active", [fields.Active.visible && fields.Active.required ? ew.Validators.required(fields.Active.caption) : null], fields.Active.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Level": <?= $Page->Level->toClientList($Page) ?>,
            "Position": <?= $Page->Position->toClientList($Page) ?>,
            "Employee": <?= $Page->Employee->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasteruserupdate" id="fmasteruserupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masteruser">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_masteruserupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->FirstName->Visible && (!$Page->isConfirm() || $Page->FirstName->multiUpdateSelected())) { // FirstName ?>
    <div id="r_FirstName"<?= $Page->FirstName->rowAttributes() ?>>
        <label for="x_FirstName" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_FirstName" id="u_FirstName" class="form-check-input ew-multi-select" value="1"<?= $Page->FirstName->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_FirstName"><?= $Page->FirstName->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FirstName->cellAttributes() ?>>
                <span id="el_masteruser_FirstName">
                <input type="<?= $Page->FirstName->getInputTextType() ?>" name="x_FirstName" id="x_FirstName" data-table="masteruser" data-field="x_FirstName" value="<?= $Page->FirstName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FirstName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FirstName->formatPattern()) ?>"<?= $Page->FirstName->editAttributes() ?> aria-describedby="x_FirstName_help">
                <?= $Page->FirstName->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->FirstName->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->LastName->Visible && (!$Page->isConfirm() || $Page->LastName->multiUpdateSelected())) { // LastName ?>
    <div id="r_LastName"<?= $Page->LastName->rowAttributes() ?>>
        <label for="x_LastName" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_LastName" id="u_LastName" class="form-check-input ew-multi-select" value="1"<?= $Page->LastName->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_LastName"><?= $Page->LastName->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->LastName->cellAttributes() ?>>
                <span id="el_masteruser_LastName">
                <input type="<?= $Page->LastName->getInputTextType() ?>" name="x_LastName" id="x_LastName" data-table="masteruser" data-field="x_LastName" value="<?= $Page->LastName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->LastName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LastName->formatPattern()) ?>"<?= $Page->LastName->editAttributes() ?> aria-describedby="x_LastName_help">
                <?= $Page->LastName->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->LastName->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Username->Visible && (!$Page->isConfirm() || $Page->_Username->multiUpdateSelected())) { // Username ?>
    <div id="r__Username"<?= $Page->_Username->rowAttributes() ?>>
        <label for="x__Username" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u__Username" id="u__Username" class="form-check-input ew-multi-select" value="1"<?= $Page->_Username->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u__Username"><?= $Page->_Username->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Username->cellAttributes() ?>>
                <span id="el_masteruser__Username">
                <input type="<?= $Page->_Username->getInputTextType() ?>" name="x__Username" id="x__Username" data-table="masteruser" data-field="x__Username" value="<?= $Page->_Username->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Username->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Username->formatPattern()) ?>"<?= $Page->_Username->editAttributes() ?> aria-describedby="x__Username_help">
                <?= $Page->_Username->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->_Username->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->UserPassword->Visible && (!$Page->isConfirm() || $Page->UserPassword->multiUpdateSelected())) { // UserPassword ?>
    <div id="r_UserPassword"<?= $Page->UserPassword->rowAttributes() ?>>
        <label for="x_UserPassword" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_UserPassword" id="u_UserPassword" class="form-check-input ew-multi-select" value="1"<?= $Page->UserPassword->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_UserPassword"><?= $Page->UserPassword->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->UserPassword->cellAttributes() ?>>
                <span id="el_masteruser_UserPassword">
                <div class="input-group">
                    <input type="password" name="x_UserPassword" id="x_UserPassword" autocomplete="new-password" data-field="x_UserPassword" value="<?= $Page->UserPassword->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->UserPassword->getPlaceHolder()) ?>"<?= $Page->UserPassword->editAttributes() ?> aria-describedby="x_UserPassword_help">
                    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
                </div>
                <?= $Page->UserPassword->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->UserPassword->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Level->Visible && (!$Page->isConfirm() || $Page->Level->multiUpdateSelected())) { // Level ?>
    <div id="r_Level"<?= $Page->Level->rowAttributes() ?>>
        <label for="x_Level" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Level" id="u_Level" class="form-check-input ew-multi-select" value="1"<?= $Page->Level->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Level"><?= $Page->Level->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Level->cellAttributes() ?>>
                <?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
                <span id="el_masteruser_Level">
                <span class="form-control-plaintext"><?= $Page->Level->getDisplayValue($Page->Level->EditValue) ?></span>
                </span>
                <?php } else { ?>
                <span id="el_masteruser_Level">
                    <select
                        id="x_Level"
                        name="x_Level"
                        class="form-select ew-select<?= $Page->Level->isInvalidClass() ?>"
                        <?php if (!$Page->Level->IsNativeSelect) { ?>
                        data-select2-id="fmasteruserupdate_x_Level"
                        <?php } ?>
                        data-table="masteruser"
                        data-field="x_Level"
                        data-value-separator="<?= $Page->Level->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->Level->getPlaceHolder()) ?>"
                        <?= $Page->Level->editAttributes() ?>>
                        <?= $Page->Level->selectOptionListHtml("x_Level") ?>
                    </select>
                    <?= $Page->Level->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->Level->getErrorMessage() ?></div>
                <?= $Page->Level->Lookup->getParamTag($Page, "p_x_Level") ?>
                <?php if (!$Page->Level->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fmasteruserupdate", function() {
                    var options = { name: "x_Level", selectId: "fmasteruserupdate_x_Level" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fmasteruserupdate.lists.Level?.lookupOptions.length) {
                        options.data = { id: "x_Level", form: "fmasteruserupdate" };
                    } else {
                        options.ajax = { id: "x_Level", form: "fmasteruserupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masteruser.fields.Level.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible && (!$Page->isConfirm() || $Page->_Email->multiUpdateSelected())) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label for="x__Email" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u__Email" id="u__Email" class="form-check-input ew-multi-select" value="1"<?= $Page->_Email->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u__Email"><?= $Page->_Email->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Email->cellAttributes() ?>>
                <span id="el_masteruser__Email">
                <input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="masteruser" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
                <?= $Page->_Email->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Position->Visible && (!$Page->isConfirm() || $Page->Position->multiUpdateSelected())) { // Position ?>
    <div id="r_Position"<?= $Page->Position->rowAttributes() ?>>
        <label for="x_Position" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Position" id="u_Position" class="form-check-input ew-multi-select" value="1"<?= $Page->Position->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Position"><?= $Page->Position->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Position->cellAttributes() ?>>
                <span id="el_masteruser_Position">
                    <select
                        id="x_Position"
                        name="x_Position"
                        class="form-select ew-select<?= $Page->Position->isInvalidClass() ?>"
                        <?php if (!$Page->Position->IsNativeSelect) { ?>
                        data-select2-id="fmasteruserupdate_x_Position"
                        <?php } ?>
                        data-table="masteruser"
                        data-field="x_Position"
                        data-value-separator="<?= $Page->Position->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>"
                        <?= $Page->Position->editAttributes() ?>>
                        <?= $Page->Position->selectOptionListHtml("x_Position") ?>
                    </select>
                    <?= $Page->Position->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->Position->getErrorMessage() ?></div>
                <?php if (!$Page->Position->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fmasteruserupdate", function() {
                    var options = { name: "x_Position", selectId: "fmasteruserupdate_x_Position" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fmasteruserupdate.lists.Position?.lookupOptions.length) {
                        options.data = { id: "x_Position", form: "fmasteruserupdate" };
                    } else {
                        options.ajax = { id: "x_Position", form: "fmasteruserupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumInputLength = ew.selectMinimumInputLength;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masteruser.fields.Position.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Department->Visible && (!$Page->isConfirm() || $Page->Department->multiUpdateSelected())) { // Department ?>
    <div id="r_Department"<?= $Page->Department->rowAttributes() ?>>
        <label for="x_Department" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Department" id="u_Department" class="form-check-input ew-multi-select" value="1"<?= $Page->Department->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Department"><?= $Page->Department->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Department->cellAttributes() ?>>
                <span id="el_masteruser_Department">
                <input type="<?= $Page->Department->getInputTextType() ?>" name="x_Department" id="x_Department" data-table="masteruser" data-field="x_Department" value="<?= $Page->Department->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Department->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Department->formatPattern()) ?>"<?= $Page->Department->editAttributes() ?> aria-describedby="x_Department_help">
                <?= $Page->Department->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->Department->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Employee->Visible && (!$Page->isConfirm() || $Page->Employee->multiUpdateSelected())) { // Employee ?>
    <div id="r_Employee"<?= $Page->Employee->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Employee" id="u_Employee" class="form-check-input ew-multi-select" value="1"<?= $Page->Employee->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Employee"><?= $Page->Employee->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Employee->cellAttributes() ?>>
                <span id="el_masteruser_Employee">
                <div class="form-check d-inline-block">
                    <input type="checkbox" class="form-check-input<?= $Page->Employee->isInvalidClass() ?>" data-table="masteruser" data-field="x_Employee" data-boolean name="x_Employee" id="x_Employee" value="1"<?= ConvertToBool($Page->Employee->CurrentValue) ? " checked" : "" ?><?= $Page->Employee->editAttributes() ?> aria-describedby="x_Employee_help">
                    <div class="invalid-feedback"><?= $Page->Employee->getErrorMessage() ?></div>
                </div>
                <?= $Page->Employee->getCustomMessage() ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->WhatsAppNumber->Visible && (!$Page->isConfirm() || $Page->WhatsAppNumber->multiUpdateSelected())) { // WhatsAppNumber ?>
    <div id="r_WhatsAppNumber"<?= $Page->WhatsAppNumber->rowAttributes() ?>>
        <label for="x_WhatsAppNumber" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_WhatsAppNumber" id="u_WhatsAppNumber" class="form-check-input ew-multi-select" value="1"<?= $Page->WhatsAppNumber->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_WhatsAppNumber"><?= $Page->WhatsAppNumber->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->WhatsAppNumber->cellAttributes() ?>>
                <span id="el_masteruser_WhatsAppNumber">
                <input type="<?= $Page->WhatsAppNumber->getInputTextType() ?>" name="x_WhatsAppNumber" id="x_WhatsAppNumber" data-table="masteruser" data-field="x_WhatsAppNumber" value="<?= $Page->WhatsAppNumber->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->WhatsAppNumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WhatsAppNumber->formatPattern()) ?>"<?= $Page->WhatsAppNumber->editAttributes() ?> aria-describedby="x_WhatsAppNumber_help">
                <?= $Page->WhatsAppNumber->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->WhatsAppNumber->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible && (!$Page->isConfirm() || $Page->Active->multiUpdateSelected())) { // Active ?>
    <div id="r_Active"<?= $Page->Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Active" id="u_Active" class="form-check-input ew-multi-select" value="1"<?= $Page->Active->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Active"><?= $Page->Active->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Active->cellAttributes() ?>>
                <span id="el_masteruser_Active">
                <div class="form-check d-inline-block">
                    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masteruser" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->CurrentValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?> aria-describedby="x_Active_help">
                    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage() ?></div>
                </div>
                <?= $Page->Active->getCustomMessage() ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmasteruserupdate"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasteruserupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masteruser");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
