<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjectdocumentsGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojectdocumentsgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projectdocuments: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojectdocumentsgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["DocDate", [fields.DocDate.visible && fields.DocDate.required ? ew.Validators.required(fields.DocDate.caption) : null, ew.Validators.datetime(fields.DocDate.clientFormatPattern)], fields.DocDate.isInvalid],
            ["DocumentTitle", [fields.DocumentTitle.visible && fields.DocumentTitle.required ? ew.Validators.required(fields.DocumentTitle.caption) : null], fields.DocumentTitle.isInvalid],
            ["DocumentFile", [fields.DocumentFile.visible && fields.DocumentFile.required ? ew.Validators.fileRequired(fields.DocumentFile.caption) : null], fields.DocumentFile.isInvalid],
            ["DocumentType", [fields.DocumentType.visible && fields.DocumentType.required ? ew.Validators.required(fields.DocumentType.caption) : null], fields.DocumentType.isInvalid],
            ["_ProjectID", [fields._ProjectID.visible && fields._ProjectID.required ? ew.Validators.required(fields._ProjectID.caption) : null], fields._ProjectID.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["DocDate",false],["DocumentTitle",false],["DocumentFile",false],["DocumentType",false],["_ProjectID",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DocumentType": <?= $Grid->DocumentType->toClientList($Grid) ?>,
            "_ProjectID": <?= $Grid->_ProjectID->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojectdocumentsgrid" class="ew-form ew-list-form">
<div id="gmp_projectdocuments" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projectdocumentsgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->DocDate->Visible) { // DocDate ?>
        <th data-name="DocDate" class="<?= $Grid->DocDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments_DocDate" class="projectdocuments_DocDate"><?= $Grid->renderFieldHeader($Grid->DocDate) ?></div></th>
<?php } ?>
<?php if ($Grid->DocumentTitle->Visible) { // DocumentTitle ?>
        <th data-name="DocumentTitle" class="<?= $Grid->DocumentTitle->headerCellClass() ?>"><div id="elh_projectdocuments_DocumentTitle" class="projectdocuments_DocumentTitle"><?= $Grid->renderFieldHeader($Grid->DocumentTitle) ?></div></th>
<?php } ?>
<?php if ($Grid->DocumentFile->Visible) { // DocumentFile ?>
        <th data-name="DocumentFile" class="<?= $Grid->DocumentFile->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments_DocumentFile" class="projectdocuments_DocumentFile"><?= $Grid->renderFieldHeader($Grid->DocumentFile) ?></div></th>
<?php } ?>
<?php if ($Grid->DocumentType->Visible) { // DocumentType ?>
        <th data-name="DocumentType" class="<?= $Grid->DocumentType->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments_DocumentType" class="projectdocuments_DocumentType"><?= $Grid->renderFieldHeader($Grid->DocumentType) ?></div></th>
<?php } ?>
<?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Grid->_ProjectID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments__ProjectID" class="projectdocuments__ProjectID"><?= $Grid->renderFieldHeader($Grid->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments_Created_Date" class="projectdocuments_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments_Created_By" class="projectdocuments_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments_Last_Updated_Date" class="projectdocuments_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectdocuments_Last_Updated_By" class="projectdocuments_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->DocDate->Visible) { // DocDate ?>
        <td data-name="DocDate"<?= $Grid->DocDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocDate" class="el_projectdocuments_DocDate">
<input type="<?= $Grid->DocDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DocDate" id="x<?= $Grid->RowIndex ?>_DocDate" data-table="projectdocuments" data-field="x_DocDate" value="<?= $Grid->DocDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->DocDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DocDate->formatPattern()) ?>"<?= $Grid->DocDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DocDate->getErrorMessage() ?></div>
<?php if (!$Grid->DocDate->ReadOnly && !$Grid->DocDate->Disabled && !isset($Grid->DocDate->EditAttrs["readonly"]) && !isset($Grid->DocDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectdocumentsgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectdocumentsgrid", "x<?= $Grid->RowIndex ?>_DocDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectdocuments" data-field="x_DocDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DocDate" id="o<?= $Grid->RowIndex ?>_DocDate" value="<?= HtmlEncode($Grid->DocDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocDate" class="el_projectdocuments_DocDate">
<input type="<?= $Grid->DocDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DocDate" id="x<?= $Grid->RowIndex ?>_DocDate" data-table="projectdocuments" data-field="x_DocDate" value="<?= $Grid->DocDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->DocDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DocDate->formatPattern()) ?>"<?= $Grid->DocDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DocDate->getErrorMessage() ?></div>
<?php if (!$Grid->DocDate->ReadOnly && !$Grid->DocDate->Disabled && !isset($Grid->DocDate->EditAttrs["readonly"]) && !isset($Grid->DocDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectdocumentsgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectdocumentsgrid", "x<?= $Grid->RowIndex ?>_DocDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocDate" class="el_projectdocuments_DocDate">
<span<?= $Grid->DocDate->viewAttributes() ?>>
<?= $Grid->DocDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x_DocDate" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_DocDate" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_DocDate" value="<?= HtmlEncode($Grid->DocDate->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x_DocDate" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_DocDate" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_DocDate" value="<?= HtmlEncode($Grid->DocDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DocumentTitle->Visible) { // DocumentTitle ?>
        <td data-name="DocumentTitle"<?= $Grid->DocumentTitle->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentTitle" class="el_projectdocuments_DocumentTitle">
<input type="<?= $Grid->DocumentTitle->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DocumentTitle" id="x<?= $Grid->RowIndex ?>_DocumentTitle" data-table="projectdocuments" data-field="x_DocumentTitle" value="<?= $Grid->DocumentTitle->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->DocumentTitle->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DocumentTitle->formatPattern()) ?>"<?= $Grid->DocumentTitle->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DocumentTitle->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projectdocuments" data-field="x_DocumentTitle" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DocumentTitle" id="o<?= $Grid->RowIndex ?>_DocumentTitle" value="<?= HtmlEncode($Grid->DocumentTitle->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentTitle" class="el_projectdocuments_DocumentTitle">
<input type="<?= $Grid->DocumentTitle->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DocumentTitle" id="x<?= $Grid->RowIndex ?>_DocumentTitle" data-table="projectdocuments" data-field="x_DocumentTitle" value="<?= $Grid->DocumentTitle->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->DocumentTitle->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DocumentTitle->formatPattern()) ?>"<?= $Grid->DocumentTitle->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DocumentTitle->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentTitle" class="el_projectdocuments_DocumentTitle">
<span<?= $Grid->DocumentTitle->viewAttributes() ?>>
<?= $Grid->DocumentTitle->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x_DocumentTitle" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_DocumentTitle" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_DocumentTitle" value="<?= HtmlEncode($Grid->DocumentTitle->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x_DocumentTitle" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_DocumentTitle" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_DocumentTitle" value="<?= HtmlEncode($Grid->DocumentTitle->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DocumentFile->Visible) { // DocumentFile ?>
        <td data-name="DocumentFile"<?= $Grid->DocumentFile->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_projectdocuments_DocumentFile" class="el_projectdocuments_DocumentFile">
<div id="fd_x<?= $Grid->RowIndex ?>_DocumentFile" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_DocumentFile"
        name="x<?= $Grid->RowIndex ?>_DocumentFile"
        class="form-control ew-file-input"
        title="<?= $Grid->DocumentFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectdocuments"
        data-field="x_DocumentFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->DocumentFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->DocumentFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->DocumentFile->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->DocumentFile->ReadOnly || $Grid->DocumentFile->Disabled) ? " disabled" : "" ?>
        <?= $Grid->DocumentFile->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->DocumentFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fn_x<?= $Grid->RowIndex ?>_DocumentFile" value="<?= $Grid->DocumentFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fa_x<?= $Grid->RowIndex ?>_DocumentFile" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_DocumentFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_projectdocuments_DocumentFile" class="el_projectdocuments_DocumentFile">
<div id="fd_x<?= $Grid->RowIndex ?>_DocumentFile">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_DocumentFile"
        name="x<?= $Grid->RowIndex ?>_DocumentFile"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->DocumentFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectdocuments"
        data-field="x_DocumentFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->DocumentFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->DocumentFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->DocumentFile->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->DocumentFile->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->DocumentFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fn_x<?= $Grid->RowIndex ?>_DocumentFile" value="<?= $Grid->DocumentFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fa_x<?= $Grid->RowIndex ?>_DocumentFile" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_DocumentFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="projectdocuments" data-field="x_DocumentFile" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DocumentFile" id="o<?= $Grid->RowIndex ?>_DocumentFile" value="<?= HtmlEncode($Grid->DocumentFile->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentFile" class="el_projectdocuments_DocumentFile">
<span<?= $Grid->DocumentFile->viewAttributes() ?>>
<?= GetFileViewTag($Grid->DocumentFile, $Grid->DocumentFile->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentFile" class="el_projectdocuments_DocumentFile">
<div id="fd_x<?= $Grid->RowIndex ?>_DocumentFile" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_DocumentFile"
        name="x<?= $Grid->RowIndex ?>_DocumentFile"
        class="form-control ew-file-input"
        title="<?= $Grid->DocumentFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectdocuments"
        data-field="x_DocumentFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->DocumentFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->DocumentFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->DocumentFile->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->DocumentFile->ReadOnly || $Grid->DocumentFile->Disabled) ? " disabled" : "" ?>
        <?= $Grid->DocumentFile->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->DocumentFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fn_x<?= $Grid->RowIndex ?>_DocumentFile" value="<?= $Grid->DocumentFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fa_x<?= $Grid->RowIndex ?>_DocumentFile" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_DocumentFile") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_DocumentFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentFile" class="el_projectdocuments_DocumentFile">
<div id="fd_x<?= $Grid->RowIndex ?>_DocumentFile">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_DocumentFile"
        name="x<?= $Grid->RowIndex ?>_DocumentFile"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->DocumentFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectdocuments"
        data-field="x_DocumentFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->DocumentFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->DocumentFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->DocumentFile->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->DocumentFile->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->DocumentFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fn_x<?= $Grid->RowIndex ?>_DocumentFile" value="<?= $Grid->DocumentFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_DocumentFile" id= "fa_x<?= $Grid->RowIndex ?>_DocumentFile" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_DocumentFile") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_DocumentFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DocumentType->Visible) { // DocumentType ?>
        <td data-name="DocumentType"<?= $Grid->DocumentType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentType" class="el_projectdocuments_DocumentType">
    <select
        id="x<?= $Grid->RowIndex ?>_DocumentType"
        name="x<?= $Grid->RowIndex ?>_DocumentType"
        class="form-select ew-select<?= $Grid->DocumentType->isInvalidClass() ?>"
        <?php if (!$Grid->DocumentType->IsNativeSelect) { ?>
        data-select2-id="fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>_DocumentType"
        <?php } ?>
        data-table="projectdocuments"
        data-field="x_DocumentType"
        data-value-separator="<?= $Grid->DocumentType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DocumentType->getPlaceHolder()) ?>"
        <?= $Grid->DocumentType->editAttributes() ?>>
        <?= $Grid->DocumentType->selectOptionListHtml("x{$Grid->RowIndex}_DocumentType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DocumentType->getErrorMessage() ?></div>
<?php if (!$Grid->DocumentType->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectdocumentsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DocumentType", selectId: "fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>_DocumentType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectdocumentsgrid.lists.DocumentType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DocumentType", form: "fprojectdocumentsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DocumentType", form: "fprojectdocumentsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectdocuments.fields.DocumentType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectdocuments" data-field="x_DocumentType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DocumentType" id="o<?= $Grid->RowIndex ?>_DocumentType" value="<?= HtmlEncode($Grid->DocumentType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentType" class="el_projectdocuments_DocumentType">
    <select
        id="x<?= $Grid->RowIndex ?>_DocumentType"
        name="x<?= $Grid->RowIndex ?>_DocumentType"
        class="form-select ew-select<?= $Grid->DocumentType->isInvalidClass() ?>"
        <?php if (!$Grid->DocumentType->IsNativeSelect) { ?>
        data-select2-id="fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>_DocumentType"
        <?php } ?>
        data-table="projectdocuments"
        data-field="x_DocumentType"
        data-value-separator="<?= $Grid->DocumentType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DocumentType->getPlaceHolder()) ?>"
        <?= $Grid->DocumentType->editAttributes() ?>>
        <?= $Grid->DocumentType->selectOptionListHtml("x{$Grid->RowIndex}_DocumentType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DocumentType->getErrorMessage() ?></div>
<?php if (!$Grid->DocumentType->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectdocumentsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DocumentType", selectId: "fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>_DocumentType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectdocumentsgrid.lists.DocumentType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DocumentType", form: "fprojectdocumentsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DocumentType", form: "fprojectdocumentsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectdocuments.fields.DocumentType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_DocumentType" class="el_projectdocuments_DocumentType">
<span<?= $Grid->DocumentType->viewAttributes() ?>>
<?= $Grid->DocumentType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x_DocumentType" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_DocumentType" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_DocumentType" value="<?= HtmlEncode($Grid->DocumentType->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x_DocumentType" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_DocumentType" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_DocumentType" value="<?= HtmlEncode($Grid->DocumentType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Grid->_ProjectID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments__ProjectID" class="el_projectdocuments__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectdocuments"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectdocumentsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectdocumentsgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectdocumentsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectdocumentsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectdocuments.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projectdocuments" data-field="x__ProjectID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__ProjectID" id="o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments__ProjectID" class="el_projectdocuments__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectdocuments"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectdocumentsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectdocumentsgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectdocumentsgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectdocumentsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectdocumentsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectdocuments.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments__ProjectID" class="el_projectdocuments__ProjectID">
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<?= $Grid->_ProjectID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x__ProjectID" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>__ProjectID" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x__ProjectID" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>__ProjectID" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Created_Date" class="el_projectdocuments_Created_Date">
<input type="hidden" data-table="projectdocuments" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectdocuments" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Created_Date" class="el_projectdocuments_Created_Date">
<input type="hidden" data-table="projectdocuments" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Created_Date" class="el_projectdocuments_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x_Created_Date" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x_Created_Date" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Created_By" class="el_projectdocuments_Created_By">
<input type="hidden" data-table="projectdocuments" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectdocuments" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Created_By" class="el_projectdocuments_Created_By">
<input type="hidden" data-table="projectdocuments" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Created_By" class="el_projectdocuments_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x_Created_By" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x_Created_By" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectdocuments" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Last_Updated_Date" class="el_projectdocuments_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectdocuments" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectdocuments_Last_Updated_By" class="el_projectdocuments_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectdocuments" data-field="x_Last_Updated_By" data-hidden="1" name="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectdocumentsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projectdocuments" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectdocumentsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojectdocumentsgrid","load"], () => fprojectdocumentsgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojectdocumentsgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectdocuments");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
