<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjectproblemsGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojectproblemsgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projectproblems: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojectproblemsgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProblemDate", [fields.ProblemDate.visible && fields.ProblemDate.required ? ew.Validators.required(fields.ProblemDate.caption) : null, ew.Validators.datetime(fields.ProblemDate.clientFormatPattern)], fields.ProblemDate.isInvalid],
            ["ProblemDescription", [fields.ProblemDescription.visible && fields.ProblemDescription.required ? ew.Validators.required(fields.ProblemDescription.caption) : null], fields.ProblemDescription.isInvalid],
            ["SolutionDescription", [fields.SolutionDescription.visible && fields.SolutionDescription.required ? ew.Validators.required(fields.SolutionDescription.caption) : null], fields.SolutionDescription.isInvalid],
            ["AriseById", [fields.AriseById.visible && fields.AriseById.required ? ew.Validators.required(fields.AriseById.caption) : null], fields.AriseById.isInvalid],
            ["SolvedById", [fields.SolvedById.visible && fields.SolvedById.required ? ew.Validators.required(fields.SolvedById.caption) : null], fields.SolvedById.isInvalid],
            ["ProblemFile", [fields.ProblemFile.visible && fields.ProblemFile.required ? ew.Validators.fileRequired(fields.ProblemFile.caption) : null], fields.ProblemFile.isInvalid],
            ["_ProjectID", [fields._ProjectID.visible && fields._ProjectID.required ? ew.Validators.required(fields._ProjectID.caption) : null], fields._ProjectID.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProblemDate",false],["ProblemDescription",false],["SolutionDescription",false],["AriseById",false],["SolvedById",false],["ProblemFile",false],["_ProjectID",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "AriseById": <?= $Grid->AriseById->toClientList($Grid) ?>,
            "SolvedById": <?= $Grid->SolvedById->toClientList($Grid) ?>,
            "_ProjectID": <?= $Grid->_ProjectID->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojectproblemsgrid" class="ew-form ew-list-form">
<div id="gmp_projectproblems" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projectproblemsgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProblemDate->Visible) { // ProblemDate ?>
        <th data-name="ProblemDate" class="<?= $Grid->ProblemDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_ProblemDate" class="projectproblems_ProblemDate"><?= $Grid->renderFieldHeader($Grid->ProblemDate) ?></div></th>
<?php } ?>
<?php if ($Grid->ProblemDescription->Visible) { // ProblemDescription ?>
        <th data-name="ProblemDescription" class="<?= $Grid->ProblemDescription->headerCellClass() ?>"><div id="elh_projectproblems_ProblemDescription" class="projectproblems_ProblemDescription"><?= $Grid->renderFieldHeader($Grid->ProblemDescription) ?></div></th>
<?php } ?>
<?php if ($Grid->SolutionDescription->Visible) { // SolutionDescription ?>
        <th data-name="SolutionDescription" class="<?= $Grid->SolutionDescription->headerCellClass() ?>"><div id="elh_projectproblems_SolutionDescription" class="projectproblems_SolutionDescription"><?= $Grid->renderFieldHeader($Grid->SolutionDescription) ?></div></th>
<?php } ?>
<?php if ($Grid->AriseById->Visible) { // AriseById ?>
        <th data-name="AriseById" class="<?= $Grid->AriseById->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_AriseById" class="projectproblems_AriseById"><?= $Grid->renderFieldHeader($Grid->AriseById) ?></div></th>
<?php } ?>
<?php if ($Grid->SolvedById->Visible) { // SolvedById ?>
        <th data-name="SolvedById" class="<?= $Grid->SolvedById->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_SolvedById" class="projectproblems_SolvedById"><?= $Grid->renderFieldHeader($Grid->SolvedById) ?></div></th>
<?php } ?>
<?php if ($Grid->ProblemFile->Visible) { // ProblemFile ?>
        <th data-name="ProblemFile" class="<?= $Grid->ProblemFile->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_ProblemFile" class="projectproblems_ProblemFile"><?= $Grid->renderFieldHeader($Grid->ProblemFile) ?></div></th>
<?php } ?>
<?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Grid->_ProjectID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems__ProjectID" class="projectproblems__ProjectID"><?= $Grid->renderFieldHeader($Grid->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_Created_Date" class="projectproblems_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_Created_By" class="projectproblems_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_Last_Updated_Date" class="projectproblems_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectproblems_Last_Updated_By" class="projectproblems_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProblemDate->Visible) { // ProblemDate ?>
        <td data-name="ProblemDate"<?= $Grid->ProblemDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemDate" class="el_projectproblems_ProblemDate">
<input type="<?= $Grid->ProblemDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ProblemDate" id="x<?= $Grid->RowIndex ?>_ProblemDate" data-table="projectproblems" data-field="x_ProblemDate" value="<?= $Grid->ProblemDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->ProblemDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ProblemDate->formatPattern()) ?>"<?= $Grid->ProblemDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ProblemDate->getErrorMessage() ?></div>
<?php if (!$Grid->ProblemDate->ReadOnly && !$Grid->ProblemDate->Disabled && !isset($Grid->ProblemDate->EditAttrs["readonly"]) && !isset($Grid->ProblemDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemsgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemsgrid", "x<?= $Grid->RowIndex ?>_ProblemDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectproblems" data-field="x_ProblemDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProblemDate" id="o<?= $Grid->RowIndex ?>_ProblemDate" value="<?= HtmlEncode($Grid->ProblemDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemDate" class="el_projectproblems_ProblemDate">
<input type="<?= $Grid->ProblemDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ProblemDate" id="x<?= $Grid->RowIndex ?>_ProblemDate" data-table="projectproblems" data-field="x_ProblemDate" value="<?= $Grid->ProblemDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->ProblemDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ProblemDate->formatPattern()) ?>"<?= $Grid->ProblemDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ProblemDate->getErrorMessage() ?></div>
<?php if (!$Grid->ProblemDate->ReadOnly && !$Grid->ProblemDate->Disabled && !isset($Grid->ProblemDate->EditAttrs["readonly"]) && !isset($Grid->ProblemDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemsgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemsgrid", "x<?= $Grid->RowIndex ?>_ProblemDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemDate" class="el_projectproblems_ProblemDate">
<span<?= $Grid->ProblemDate->viewAttributes() ?>>
<?= $Grid->ProblemDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_ProblemDate" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_ProblemDate" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_ProblemDate" value="<?= HtmlEncode($Grid->ProblemDate->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_ProblemDate" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_ProblemDate" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_ProblemDate" value="<?= HtmlEncode($Grid->ProblemDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ProblemDescription->Visible) { // ProblemDescription ?>
        <td data-name="ProblemDescription"<?= $Grid->ProblemDescription->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemDescription" class="el_projectproblems_ProblemDescription">
<?php $Grid->ProblemDescription->EditAttrs->appendClass("editor"); ?>
<textarea data-table="projectproblems" data-field="x_ProblemDescription" name="x<?= $Grid->RowIndex ?>_ProblemDescription" id="x<?= $Grid->RowIndex ?>_ProblemDescription" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->ProblemDescription->getPlaceHolder()) ?>"<?= $Grid->ProblemDescription->editAttributes() ?>><?= $Grid->ProblemDescription->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->ProblemDescription->getErrorMessage() ?></div>
<script>
loadjs.ready(["fprojectproblemsgrid", "editor"], function() {
    ew.createEditor("fprojectproblemsgrid", "x<?= $Grid->RowIndex ?>_ProblemDescription", 0, 0, <?= $Grid->ProblemDescription->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<input type="hidden" data-table="projectproblems" data-field="x_ProblemDescription" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProblemDescription" id="o<?= $Grid->RowIndex ?>_ProblemDescription" value="<?= HtmlEncode($Grid->ProblemDescription->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemDescription" class="el_projectproblems_ProblemDescription">
<?php $Grid->ProblemDescription->EditAttrs->appendClass("editor"); ?>
<textarea data-table="projectproblems" data-field="x_ProblemDescription" name="x<?= $Grid->RowIndex ?>_ProblemDescription" id="x<?= $Grid->RowIndex ?>_ProblemDescription" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->ProblemDescription->getPlaceHolder()) ?>"<?= $Grid->ProblemDescription->editAttributes() ?>><?= $Grid->ProblemDescription->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->ProblemDescription->getErrorMessage() ?></div>
<script>
loadjs.ready(["fprojectproblemsgrid", "editor"], function() {
    ew.createEditor("fprojectproblemsgrid", "x<?= $Grid->RowIndex ?>_ProblemDescription", 0, 0, <?= $Grid->ProblemDescription->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemDescription" class="el_projectproblems_ProblemDescription">
<span<?= $Grid->ProblemDescription->viewAttributes() ?>>
<?= $Grid->ProblemDescription->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_ProblemDescription" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_ProblemDescription" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_ProblemDescription" value="<?= HtmlEncode($Grid->ProblemDescription->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_ProblemDescription" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_ProblemDescription" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_ProblemDescription" value="<?= HtmlEncode($Grid->ProblemDescription->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->SolutionDescription->Visible) { // SolutionDescription ?>
        <td data-name="SolutionDescription"<?= $Grid->SolutionDescription->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_SolutionDescription" class="el_projectproblems_SolutionDescription">
<?php $Grid->SolutionDescription->EditAttrs->appendClass("editor"); ?>
<textarea data-table="projectproblems" data-field="x_SolutionDescription" name="x<?= $Grid->RowIndex ?>_SolutionDescription" id="x<?= $Grid->RowIndex ?>_SolutionDescription" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->SolutionDescription->getPlaceHolder()) ?>"<?= $Grid->SolutionDescription->editAttributes() ?>><?= $Grid->SolutionDescription->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->SolutionDescription->getErrorMessage() ?></div>
<script>
loadjs.ready(["fprojectproblemsgrid", "editor"], function() {
    ew.createEditor("fprojectproblemsgrid", "x<?= $Grid->RowIndex ?>_SolutionDescription", 0, 0, <?= $Grid->SolutionDescription->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<input type="hidden" data-table="projectproblems" data-field="x_SolutionDescription" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SolutionDescription" id="o<?= $Grid->RowIndex ?>_SolutionDescription" value="<?= HtmlEncode($Grid->SolutionDescription->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_SolutionDescription" class="el_projectproblems_SolutionDescription">
<?php $Grid->SolutionDescription->EditAttrs->appendClass("editor"); ?>
<textarea data-table="projectproblems" data-field="x_SolutionDescription" name="x<?= $Grid->RowIndex ?>_SolutionDescription" id="x<?= $Grid->RowIndex ?>_SolutionDescription" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->SolutionDescription->getPlaceHolder()) ?>"<?= $Grid->SolutionDescription->editAttributes() ?>><?= $Grid->SolutionDescription->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->SolutionDescription->getErrorMessage() ?></div>
<script>
loadjs.ready(["fprojectproblemsgrid", "editor"], function() {
    ew.createEditor("fprojectproblemsgrid", "x<?= $Grid->RowIndex ?>_SolutionDescription", 0, 0, <?= $Grid->SolutionDescription->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_SolutionDescription" class="el_projectproblems_SolutionDescription">
<span<?= $Grid->SolutionDescription->viewAttributes() ?>>
<?= $Grid->SolutionDescription->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_SolutionDescription" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_SolutionDescription" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_SolutionDescription" value="<?= HtmlEncode($Grid->SolutionDescription->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_SolutionDescription" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_SolutionDescription" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_SolutionDescription" value="<?= HtmlEncode($Grid->SolutionDescription->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->AriseById->Visible) { // AriseById ?>
        <td data-name="AriseById"<?= $Grid->AriseById->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_AriseById" class="el_projectproblems_AriseById">
    <select
        id="x<?= $Grid->RowIndex ?>_AriseById"
        name="x<?= $Grid->RowIndex ?>_AriseById"
        class="form-select ew-select<?= $Grid->AriseById->isInvalidClass() ?>"
        <?php if (!$Grid->AriseById->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_AriseById"
        <?php } ?>
        data-table="projectproblems"
        data-field="x_AriseById"
        data-value-separator="<?= $Grid->AriseById->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->AriseById->getPlaceHolder()) ?>"
        <?= $Grid->AriseById->editAttributes() ?>>
        <?= $Grid->AriseById->selectOptionListHtml("x{$Grid->RowIndex}_AriseById") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->AriseById->getErrorMessage() ?></div>
<?= $Grid->AriseById->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_AriseById") ?>
<?php if (!$Grid->AriseById->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_AriseById", selectId: "fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_AriseById" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemsgrid.lists.AriseById?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_AriseById", form: "fprojectproblemsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_AriseById", form: "fprojectproblemsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields.AriseById.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectproblems" data-field="x_AriseById" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_AriseById" id="o<?= $Grid->RowIndex ?>_AriseById" value="<?= HtmlEncode($Grid->AriseById->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_AriseById" class="el_projectproblems_AriseById">
    <select
        id="x<?= $Grid->RowIndex ?>_AriseById"
        name="x<?= $Grid->RowIndex ?>_AriseById"
        class="form-select ew-select<?= $Grid->AriseById->isInvalidClass() ?>"
        <?php if (!$Grid->AriseById->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_AriseById"
        <?php } ?>
        data-table="projectproblems"
        data-field="x_AriseById"
        data-value-separator="<?= $Grid->AriseById->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->AriseById->getPlaceHolder()) ?>"
        <?= $Grid->AriseById->editAttributes() ?>>
        <?= $Grid->AriseById->selectOptionListHtml("x{$Grid->RowIndex}_AriseById") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->AriseById->getErrorMessage() ?></div>
<?= $Grid->AriseById->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_AriseById") ?>
<?php if (!$Grid->AriseById->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_AriseById", selectId: "fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_AriseById" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemsgrid.lists.AriseById?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_AriseById", form: "fprojectproblemsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_AriseById", form: "fprojectproblemsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields.AriseById.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_AriseById" class="el_projectproblems_AriseById">
<span<?= $Grid->AriseById->viewAttributes() ?>>
<?= $Grid->AriseById->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_AriseById" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_AriseById" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_AriseById" value="<?= HtmlEncode($Grid->AriseById->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_AriseById" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_AriseById" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_AriseById" value="<?= HtmlEncode($Grid->AriseById->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->SolvedById->Visible) { // SolvedById ?>
        <td data-name="SolvedById"<?= $Grid->SolvedById->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_SolvedById" class="el_projectproblems_SolvedById">
    <select
        id="x<?= $Grid->RowIndex ?>_SolvedById"
        name="x<?= $Grid->RowIndex ?>_SolvedById"
        class="form-select ew-select<?= $Grid->SolvedById->isInvalidClass() ?>"
        <?php if (!$Grid->SolvedById->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_SolvedById"
        <?php } ?>
        data-table="projectproblems"
        data-field="x_SolvedById"
        data-value-separator="<?= $Grid->SolvedById->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SolvedById->getPlaceHolder()) ?>"
        <?= $Grid->SolvedById->editAttributes() ?>>
        <?= $Grid->SolvedById->selectOptionListHtml("x{$Grid->RowIndex}_SolvedById") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SolvedById->getErrorMessage() ?></div>
<?= $Grid->SolvedById->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SolvedById") ?>
<?php if (!$Grid->SolvedById->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SolvedById", selectId: "fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_SolvedById" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemsgrid.lists.SolvedById?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SolvedById", form: "fprojectproblemsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SolvedById", form: "fprojectproblemsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields.SolvedById.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectproblems" data-field="x_SolvedById" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SolvedById" id="o<?= $Grid->RowIndex ?>_SolvedById" value="<?= HtmlEncode($Grid->SolvedById->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_SolvedById" class="el_projectproblems_SolvedById">
    <select
        id="x<?= $Grid->RowIndex ?>_SolvedById"
        name="x<?= $Grid->RowIndex ?>_SolvedById"
        class="form-select ew-select<?= $Grid->SolvedById->isInvalidClass() ?>"
        <?php if (!$Grid->SolvedById->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_SolvedById"
        <?php } ?>
        data-table="projectproblems"
        data-field="x_SolvedById"
        data-value-separator="<?= $Grid->SolvedById->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SolvedById->getPlaceHolder()) ?>"
        <?= $Grid->SolvedById->editAttributes() ?>>
        <?= $Grid->SolvedById->selectOptionListHtml("x{$Grid->RowIndex}_SolvedById") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SolvedById->getErrorMessage() ?></div>
<?= $Grid->SolvedById->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SolvedById") ?>
<?php if (!$Grid->SolvedById->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SolvedById", selectId: "fprojectproblemsgrid_x<?= $Grid->RowIndex ?>_SolvedById" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemsgrid.lists.SolvedById?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SolvedById", form: "fprojectproblemsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SolvedById", form: "fprojectproblemsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields.SolvedById.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_SolvedById" class="el_projectproblems_SolvedById">
<span<?= $Grid->SolvedById->viewAttributes() ?>>
<?= $Grid->SolvedById->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_SolvedById" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_SolvedById" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_SolvedById" value="<?= HtmlEncode($Grid->SolvedById->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_SolvedById" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_SolvedById" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_SolvedById" value="<?= HtmlEncode($Grid->SolvedById->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ProblemFile->Visible) { // ProblemFile ?>
        <td data-name="ProblemFile"<?= $Grid->ProblemFile->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_projectproblems_ProblemFile" class="el_projectproblems_ProblemFile">
<div id="fd_x<?= $Grid->RowIndex ?>_ProblemFile" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_ProblemFile"
        name="x<?= $Grid->RowIndex ?>_ProblemFile"
        class="form-control ew-file-input"
        title="<?= $Grid->ProblemFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectproblems"
        data-field="x_ProblemFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->ProblemFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->ProblemFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->ProblemFile->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->ProblemFile->ReadOnly || $Grid->ProblemFile->Disabled) ? " disabled" : "" ?>
        <?= $Grid->ProblemFile->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->ProblemFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fn_x<?= $Grid->RowIndex ?>_ProblemFile" value="<?= $Grid->ProblemFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fa_x<?= $Grid->RowIndex ?>_ProblemFile" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_ProblemFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_projectproblems_ProblemFile" class="el_projectproblems_ProblemFile">
<div id="fd_x<?= $Grid->RowIndex ?>_ProblemFile">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_ProblemFile"
        name="x<?= $Grid->RowIndex ?>_ProblemFile"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->ProblemFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectproblems"
        data-field="x_ProblemFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->ProblemFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->ProblemFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->ProblemFile->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->ProblemFile->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->ProblemFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fn_x<?= $Grid->RowIndex ?>_ProblemFile" value="<?= $Grid->ProblemFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fa_x<?= $Grid->RowIndex ?>_ProblemFile" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_ProblemFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="projectproblems" data-field="x_ProblemFile" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProblemFile" id="o<?= $Grid->RowIndex ?>_ProblemFile" value="<?= HtmlEncode($Grid->ProblemFile->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemFile" class="el_projectproblems_ProblemFile">
<span<?= $Grid->ProblemFile->viewAttributes() ?>>
<?= GetFileViewTag($Grid->ProblemFile, $Grid->ProblemFile->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemFile" class="el_projectproblems_ProblemFile">
<div id="fd_x<?= $Grid->RowIndex ?>_ProblemFile" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_ProblemFile"
        name="x<?= $Grid->RowIndex ?>_ProblemFile"
        class="form-control ew-file-input"
        title="<?= $Grid->ProblemFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectproblems"
        data-field="x_ProblemFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->ProblemFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->ProblemFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->ProblemFile->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->ProblemFile->ReadOnly || $Grid->ProblemFile->Disabled) ? " disabled" : "" ?>
        <?= $Grid->ProblemFile->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->ProblemFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fn_x<?= $Grid->RowIndex ?>_ProblemFile" value="<?= $Grid->ProblemFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fa_x<?= $Grid->RowIndex ?>_ProblemFile" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_ProblemFile") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_ProblemFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_ProblemFile" class="el_projectproblems_ProblemFile">
<div id="fd_x<?= $Grid->RowIndex ?>_ProblemFile">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_ProblemFile"
        name="x<?= $Grid->RowIndex ?>_ProblemFile"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->ProblemFile->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectproblems"
        data-field="x_ProblemFile"
        data-size="500"
        data-accept-file-types="<?= $Grid->ProblemFile->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->ProblemFile->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->ProblemFile->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->ProblemFile->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->ProblemFile->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fn_x<?= $Grid->RowIndex ?>_ProblemFile" value="<?= $Grid->ProblemFile->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_ProblemFile" id= "fa_x<?= $Grid->RowIndex ?>_ProblemFile" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_ProblemFile") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_ProblemFile" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Grid->_ProjectID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems__ProjectID" class="el_projectproblems__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemsgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectproblems"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectproblemsgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemsgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectproblemsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectproblemsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projectproblems" data-field="x__ProjectID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__ProjectID" id="o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems__ProjectID" class="el_projectproblems__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemsgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectproblems"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemsgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectproblemsgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemsgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectproblemsgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectproblemsgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems__ProjectID" class="el_projectproblems__ProjectID">
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<?= $Grid->_ProjectID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x__ProjectID" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>__ProjectID" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x__ProjectID" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>__ProjectID" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Created_Date" class="el_projectproblems_Created_Date">
<input type="hidden" data-table="projectproblems" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectproblems" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Created_Date" class="el_projectproblems_Created_Date">
<input type="hidden" data-table="projectproblems" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Created_Date" class="el_projectproblems_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_Created_Date" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_Created_Date" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Created_By" class="el_projectproblems_Created_By">
<input type="hidden" data-table="projectproblems" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectproblems" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Created_By" class="el_projectproblems_Created_By">
<input type="hidden" data-table="projectproblems" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Created_By" class="el_projectproblems_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_Created_By" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_Created_By" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectproblems" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Last_Updated_Date" class="el_projectproblems_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectproblems" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectproblems_Last_Updated_By" class="el_projectproblems_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectproblems" data-field="x_Last_Updated_By" data-hidden="1" name="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectproblemsgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projectproblems" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectproblemsgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojectproblemsgrid","load"], () => fprojectproblemsgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojectproblemsgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectproblems");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
