<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjectresultGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojectresultgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projectresult: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojectresultgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["Activities", [fields.Activities.visible && fields.Activities.required ? ew.Validators.required(fields.Activities.caption) : null], fields.Activities.isInvalid],
            ["DateDelivered", [fields.DateDelivered.visible && fields.DateDelivered.required ? ew.Validators.required(fields.DateDelivered.caption) : null, ew.Validators.datetime(fields.DateDelivered.clientFormatPattern)], fields.DateDelivered.isInvalid],
            ["Progress", [fields.Progress.visible && fields.Progress.required ? ew.Validators.required(fields.Progress.caption) : null, ew.Validators.float], fields.Progress.isInvalid],
            ["Status", [fields.Status.visible && fields.Status.required ? ew.Validators.required(fields.Status.caption) : null], fields.Status.isInvalid],
            ["Category", [fields.Category.visible && fields.Category.required ? ew.Validators.required(fields.Category.caption) : null], fields.Category.isInvalid],
            ["Weight", [fields.Weight.visible && fields.Weight.required ? ew.Validators.required(fields.Weight.caption) : null, ew.Validators.integer], fields.Weight.isInvalid],
            ["File", [fields.File.visible && fields.File.required ? ew.Validators.fileRequired(fields.File.caption) : null], fields.File.isInvalid],
            ["_ProjectID", [fields._ProjectID.visible && fields._ProjectID.required ? ew.Validators.required(fields._ProjectID.caption) : null], fields._ProjectID.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["Activities",false],["DateDelivered",false],["Progress",false],["Status",false],["Category",false],["Weight",false],["File",false],["_ProjectID",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Status": <?= $Grid->Status->toClientList($Grid) ?>,
            "Category": <?= $Grid->Category->toClientList($Grid) ?>,
            "_ProjectID": <?= $Grid->_ProjectID->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojectresultgrid" class="ew-form ew-list-form">
<div id="gmp_projectresult" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projectresultgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->Activities->Visible) { // Activities ?>
        <th data-name="Activities" class="<?= $Grid->Activities->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Activities" class="projectresult_Activities"><?= $Grid->renderFieldHeader($Grid->Activities) ?></div></th>
<?php } ?>
<?php if ($Grid->DateDelivered->Visible) { // DateDelivered ?>
        <th data-name="DateDelivered" class="<?= $Grid->DateDelivered->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_DateDelivered" class="projectresult_DateDelivered"><?= $Grid->renderFieldHeader($Grid->DateDelivered) ?></div></th>
<?php } ?>
<?php if ($Grid->Progress->Visible) { // Progress ?>
        <th data-name="Progress" class="<?= $Grid->Progress->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Progress" class="projectresult_Progress"><?= $Grid->renderFieldHeader($Grid->Progress) ?></div></th>
<?php } ?>
<?php if ($Grid->Status->Visible) { // Status ?>
        <th data-name="Status" class="<?= $Grid->Status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Status" class="projectresult_Status"><?= $Grid->renderFieldHeader($Grid->Status) ?></div></th>
<?php } ?>
<?php if ($Grid->Category->Visible) { // Category ?>
        <th data-name="Category" class="<?= $Grid->Category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Category" class="projectresult_Category"><?= $Grid->renderFieldHeader($Grid->Category) ?></div></th>
<?php } ?>
<?php if ($Grid->Weight->Visible) { // Weight ?>
        <th data-name="Weight" class="<?= $Grid->Weight->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Weight" class="projectresult_Weight"><?= $Grid->renderFieldHeader($Grid->Weight) ?></div></th>
<?php } ?>
<?php if ($Grid->File->Visible) { // File ?>
        <th data-name="File" class="<?= $Grid->File->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_File" class="projectresult_File"><?= $Grid->renderFieldHeader($Grid->File) ?></div></th>
<?php } ?>
<?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Grid->_ProjectID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult__ProjectID" class="projectresult__ProjectID"><?= $Grid->renderFieldHeader($Grid->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Created_Date" class="projectresult_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Created_By" class="projectresult_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectresult_Last_Updated_Date" class="projectresult_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>"><div id="elh_projectresult_Last_Updated_By" class="projectresult_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->Activities->Visible) { // Activities ?>
        <td data-name="Activities"<?= $Grid->Activities->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Activities" class="el_projectresult_Activities">
<textarea data-table="projectresult" data-field="x_Activities" name="x<?= $Grid->RowIndex ?>_Activities" id="x<?= $Grid->RowIndex ?>_Activities" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->Activities->getPlaceHolder()) ?>"<?= $Grid->Activities->editAttributes() ?>><?= $Grid->Activities->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->Activities->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projectresult" data-field="x_Activities" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Activities" id="o<?= $Grid->RowIndex ?>_Activities" value="<?= HtmlEncode($Grid->Activities->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Activities" class="el_projectresult_Activities">
<textarea data-table="projectresult" data-field="x_Activities" name="x<?= $Grid->RowIndex ?>_Activities" id="x<?= $Grid->RowIndex ?>_Activities" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->Activities->getPlaceHolder()) ?>"<?= $Grid->Activities->editAttributes() ?>><?= $Grid->Activities->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->Activities->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Activities" class="el_projectresult_Activities">
<span<?= $Grid->Activities->viewAttributes() ?>>
<?= $Grid->Activities->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Activities" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Activities" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Activities" value="<?= HtmlEncode($Grid->Activities->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Activities" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Activities" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Activities" value="<?= HtmlEncode($Grid->Activities->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DateDelivered->Visible) { // DateDelivered ?>
        <td data-name="DateDelivered"<?= $Grid->DateDelivered->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_DateDelivered" class="el_projectresult_DateDelivered">
<input type="<?= $Grid->DateDelivered->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DateDelivered" id="x<?= $Grid->RowIndex ?>_DateDelivered" data-table="projectresult" data-field="x_DateDelivered" value="<?= $Grid->DateDelivered->EditValue ?>" placeholder="<?= HtmlEncode($Grid->DateDelivered->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DateDelivered->formatPattern()) ?>"<?= $Grid->DateDelivered->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DateDelivered->getErrorMessage() ?></div>
<?php if (!$Grid->DateDelivered->ReadOnly && !$Grid->DateDelivered->Disabled && !isset($Grid->DateDelivered->EditAttrs["readonly"]) && !isset($Grid->DateDelivered->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultgrid", "x<?= $Grid->RowIndex ?>_DateDelivered", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectresult" data-field="x_DateDelivered" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DateDelivered" id="o<?= $Grid->RowIndex ?>_DateDelivered" value="<?= HtmlEncode($Grid->DateDelivered->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_DateDelivered" class="el_projectresult_DateDelivered">
<input type="<?= $Grid->DateDelivered->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DateDelivered" id="x<?= $Grid->RowIndex ?>_DateDelivered" data-table="projectresult" data-field="x_DateDelivered" value="<?= $Grid->DateDelivered->EditValue ?>" placeholder="<?= HtmlEncode($Grid->DateDelivered->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DateDelivered->formatPattern()) ?>"<?= $Grid->DateDelivered->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DateDelivered->getErrorMessage() ?></div>
<?php if (!$Grid->DateDelivered->ReadOnly && !$Grid->DateDelivered->Disabled && !isset($Grid->DateDelivered->EditAttrs["readonly"]) && !isset($Grid->DateDelivered->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultgrid", "x<?= $Grid->RowIndex ?>_DateDelivered", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_DateDelivered" class="el_projectresult_DateDelivered">
<span<?= $Grid->DateDelivered->viewAttributes() ?>>
<?= $Grid->DateDelivered->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_DateDelivered" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_DateDelivered" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_DateDelivered" value="<?= HtmlEncode($Grid->DateDelivered->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_DateDelivered" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_DateDelivered" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_DateDelivered" value="<?= HtmlEncode($Grid->DateDelivered->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Progress->Visible) { // Progress ?>
        <td data-name="Progress"<?= $Grid->Progress->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Progress" class="el_projectresult_Progress">
<input type="<?= $Grid->Progress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Progress" id="x<?= $Grid->RowIndex ?>_Progress" data-table="projectresult" data-field="x_Progress" value="<?= $Grid->Progress->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Progress->formatPattern()) ?>"<?= $Grid->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Progress->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projectresult" data-field="x_Progress" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Progress" id="o<?= $Grid->RowIndex ?>_Progress" value="<?= HtmlEncode($Grid->Progress->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Progress" class="el_projectresult_Progress">
<input type="<?= $Grid->Progress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Progress" id="x<?= $Grid->RowIndex ?>_Progress" data-table="projectresult" data-field="x_Progress" value="<?= $Grid->Progress->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Progress->formatPattern()) ?>"<?= $Grid->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Progress->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Progress" class="el_projectresult_Progress">
<span<?= $Grid->Progress->viewAttributes() ?>>
<?= $Grid->Progress->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Progress" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Progress" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Progress" value="<?= HtmlEncode($Grid->Progress->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Progress" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Progress" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Progress" value="<?= HtmlEncode($Grid->Progress->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Status->Visible) { // Status ?>
        <td data-name="Status"<?= $Grid->Status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Status" class="el_projectresult_Status">
    <select
        id="x<?= $Grid->RowIndex ?>_Status"
        name="x<?= $Grid->RowIndex ?>_Status"
        class="form-select ew-select<?= $Grid->Status->isInvalidClass() ?>"
        <?php if (!$Grid->Status->IsNativeSelect) { ?>
        data-select2-id="fprojectresultgrid_x<?= $Grid->RowIndex ?>_Status"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Status"
        data-value-separator="<?= $Grid->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Status->getPlaceHolder()) ?>"
        <?= $Grid->Status->editAttributes() ?>>
        <?= $Grid->Status->selectOptionListHtml("x{$Grid->RowIndex}_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Status->getErrorMessage() ?></div>
<?= $Grid->Status->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Status") ?>
<?php if (!$Grid->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Status", selectId: "fprojectresultgrid_x<?= $Grid->RowIndex ?>_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultgrid.lists.Status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Status", form: "fprojectresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Status", form: "fprojectresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectresult" data-field="x_Status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Status" id="o<?= $Grid->RowIndex ?>_Status" value="<?= HtmlEncode($Grid->Status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Status" class="el_projectresult_Status">
    <select
        id="x<?= $Grid->RowIndex ?>_Status"
        name="x<?= $Grid->RowIndex ?>_Status"
        class="form-select ew-select<?= $Grid->Status->isInvalidClass() ?>"
        <?php if (!$Grid->Status->IsNativeSelect) { ?>
        data-select2-id="fprojectresultgrid_x<?= $Grid->RowIndex ?>_Status"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Status"
        data-value-separator="<?= $Grid->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Status->getPlaceHolder()) ?>"
        <?= $Grid->Status->editAttributes() ?>>
        <?= $Grid->Status->selectOptionListHtml("x{$Grid->RowIndex}_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Status->getErrorMessage() ?></div>
<?= $Grid->Status->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Status") ?>
<?php if (!$Grid->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Status", selectId: "fprojectresultgrid_x<?= $Grid->RowIndex ?>_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultgrid.lists.Status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Status", form: "fprojectresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Status", form: "fprojectresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Status" class="el_projectresult_Status">
<span<?= $Grid->Status->viewAttributes() ?>>
<?= $Grid->Status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Status" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Status" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Status" value="<?= HtmlEncode($Grid->Status->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Status" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Status" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Status" value="<?= HtmlEncode($Grid->Status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Category->Visible) { // Category ?>
        <td data-name="Category"<?= $Grid->Category->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Category" class="el_projectresult_Category">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_Category"
        name="x<?= $Grid->RowIndex ?>_Category"
        class="form-select ew-select<?= $Grid->Category->isInvalidClass() ?>"
        <?php if (!$Grid->Category->IsNativeSelect) { ?>
        data-select2-id="fprojectresultgrid_x<?= $Grid->RowIndex ?>_Category"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Category"
        data-value-separator="<?= $Grid->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Category->getPlaceHolder()) ?>"
        <?= $Grid->Category->editAttributes() ?>>
        <?= $Grid->Category->selectOptionListHtml("x{$Grid->RowIndex}_Category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterprojectcategory") && !$Grid->Category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_Category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->Category->caption() ?>" data-title="<?= $Grid->Category->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_Category" data-url="<?= GetUrl("masterprojectcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->Category->getErrorMessage() ?></div>
<?= $Grid->Category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Category") ?>
<?php if (!$Grid->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Category", selectId: "fprojectresultgrid_x<?= $Grid->RowIndex ?>_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultgrid.lists.Category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojectresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojectresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectresult" data-field="x_Category" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Category" id="o<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Category" class="el_projectresult_Category">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_Category"
        name="x<?= $Grid->RowIndex ?>_Category"
        class="form-select ew-select<?= $Grid->Category->isInvalidClass() ?>"
        <?php if (!$Grid->Category->IsNativeSelect) { ?>
        data-select2-id="fprojectresultgrid_x<?= $Grid->RowIndex ?>_Category"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Category"
        data-value-separator="<?= $Grid->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Category->getPlaceHolder()) ?>"
        <?= $Grid->Category->editAttributes() ?>>
        <?= $Grid->Category->selectOptionListHtml("x{$Grid->RowIndex}_Category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterprojectcategory") && !$Grid->Category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_Category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->Category->caption() ?>" data-title="<?= $Grid->Category->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_Category" data-url="<?= GetUrl("masterprojectcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->Category->getErrorMessage() ?></div>
<?= $Grid->Category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Category") ?>
<?php if (!$Grid->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Category", selectId: "fprojectresultgrid_x<?= $Grid->RowIndex ?>_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultgrid.lists.Category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojectresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojectresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Category" class="el_projectresult_Category">
<span<?= $Grid->Category->viewAttributes() ?>>
<?= $Grid->Category->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Category" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Category" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Category" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Category" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Weight->Visible) { // Weight ?>
        <td data-name="Weight"<?= $Grid->Weight->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Weight" class="el_projectresult_Weight">
<input type="<?= $Grid->Weight->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Weight" id="x<?= $Grid->RowIndex ?>_Weight" data-table="projectresult" data-field="x_Weight" value="<?= $Grid->Weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Weight->formatPattern()) ?>"<?= $Grid->Weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Weight->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projectresult" data-field="x_Weight" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Weight" id="o<?= $Grid->RowIndex ?>_Weight" value="<?= HtmlEncode($Grid->Weight->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Weight" class="el_projectresult_Weight">
<input type="<?= $Grid->Weight->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Weight" id="x<?= $Grid->RowIndex ?>_Weight" data-table="projectresult" data-field="x_Weight" value="<?= $Grid->Weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Weight->formatPattern()) ?>"<?= $Grid->Weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Weight->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Weight" class="el_projectresult_Weight">
<span<?= $Grid->Weight->viewAttributes() ?>>
<?= $Grid->Weight->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Weight" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Weight" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Weight" value="<?= HtmlEncode($Grid->Weight->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Weight" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Weight" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Weight" value="<?= HtmlEncode($Grid->Weight->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->File->Visible) { // File ?>
        <td data-name="File"<?= $Grid->File->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_projectresult_File" class="el_projectresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectresult"
        data-field="x_File"
        data-size="1200"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->File->ReadOnly || $Grid->File->Disabled) ? " disabled" : "" ?>
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_projectresult_File" class="el_projectresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectresult"
        data-field="x_File"
        data-size="1200"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="projectresult" data-field="x_File" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_File" id="o<?= $Grid->RowIndex ?>_File" value="<?= HtmlEncode($Grid->File->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_File" class="el_projectresult_File">
<span<?= $Grid->File->viewAttributes() ?>>
<?= GetFileViewTag($Grid->File, $Grid->File->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_File" class="el_projectresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectresult"
        data-field="x_File"
        data-size="1200"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->File->ReadOnly || $Grid->File->Disabled) ? " disabled" : "" ?>
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_File") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_File" class="el_projectresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projectresult"
        data-field="x_File"
        data-size="1200"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_File") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Grid->_ProjectID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult__ProjectID" class="el_projectresult__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectresultgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectresult"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectresultgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projectresult" data-field="x__ProjectID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__ProjectID" id="o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult__ProjectID" class="el_projectresult__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectresultgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectresult"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectresultgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult__ProjectID" class="el_projectresult__ProjectID">
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<?= $Grid->_ProjectID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x__ProjectID" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>__ProjectID" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x__ProjectID" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>__ProjectID" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Created_Date" class="el_projectresult_Created_Date">
<input type="hidden" data-table="projectresult" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectresult" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Created_Date" class="el_projectresult_Created_Date">
<input type="hidden" data-table="projectresult" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Created_Date" class="el_projectresult_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Created_Date" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Created_Date" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Created_By" class="el_projectresult_Created_By">
<input type="hidden" data-table="projectresult" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectresult" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Created_By" class="el_projectresult_Created_By">
<input type="hidden" data-table="projectresult" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Created_By" class="el_projectresult_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Created_By" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Created_By" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectresult" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Last_Updated_Date" class="el_projectresult_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectresult" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectresult_Last_Updated_By" class="el_projectresult_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectresult" data-field="x_Last_Updated_By" data-hidden="1" name="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projectresult" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojectresultgrid","load"], () => fprojectresultgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->Activities->Visible) { // Activities ?>
        <td data-name="Activities" class="<?= $Grid->Activities->footerCellClass() ?>"><span id="elf_projectresult_Activities" class="projectresult_Activities">
        </span></td>
    <?php } ?>
    <?php if ($Grid->DateDelivered->Visible) { // DateDelivered ?>
        <td data-name="DateDelivered" class="<?= $Grid->DateDelivered->footerCellClass() ?>"><span id="elf_projectresult_DateDelivered" class="projectresult_DateDelivered">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Progress->Visible) { // Progress ?>
        <td data-name="Progress" class="<?= $Grid->Progress->footerCellClass() ?>"><span id="elf_projectresult_Progress" class="projectresult_Progress">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Grid->Progress->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->Status->Visible) { // Status ?>
        <td data-name="Status" class="<?= $Grid->Status->footerCellClass() ?>"><span id="elf_projectresult_Status" class="projectresult_Status">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Category->Visible) { // Category ?>
        <td data-name="Category" class="<?= $Grid->Category->footerCellClass() ?>"><span id="elf_projectresult_Category" class="projectresult_Category">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Weight->Visible) { // Weight ?>
        <td data-name="Weight" class="<?= $Grid->Weight->footerCellClass() ?>"><span id="elf_projectresult_Weight" class="projectresult_Weight">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->Weight->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->File->Visible) { // File ?>
        <td data-name="File" class="<?= $Grid->File->footerCellClass() ?>"><span id="elf_projectresult_File" class="projectresult_File">
        </span></td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID" class="<?= $Grid->_ProjectID->footerCellClass() ?>"><span id="elf_projectresult__ProjectID" class="projectresult__ProjectID">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date" class="<?= $Grid->Created_Date->footerCellClass() ?>"><span id="elf_projectresult_Created_Date" class="projectresult_Created_Date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By" class="<?= $Grid->Created_By->footerCellClass() ?>"><span id="elf_projectresult_Created_By" class="projectresult_Created_By">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->footerCellClass() ?>"><span id="elf_projectresult_Last_Updated_Date" class="projectresult_Last_Updated_Date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->footerCellClass() ?>"><span id="elf_projectresult_Last_Updated_By" class="projectresult_Last_Updated_By">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojectresultgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectresult");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
