<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjectresultSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projectresult: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprojectresultsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojectresultsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ResultID", [ew.Validators.integer], fields.ResultID.isInvalid],
            ["Activities", [], fields.Activities.isInvalid],
            ["DateDelivered", [ew.Validators.datetime(fields.DateDelivered.clientFormatPattern)], fields.DateDelivered.isInvalid],
            ["y_DateDelivered", [ew.Validators.between], false],
            ["Progress", [ew.Validators.float], fields.Progress.isInvalid],
            ["y_Progress", [ew.Validators.between], false],
            ["Status", [], fields.Status.isInvalid],
            ["Category", [], fields.Category.isInvalid],
            ["Weight", [ew.Validators.integer], fields.Weight.isInvalid],
            ["File", [], fields.File.isInvalid],
            ["Notes", [], fields.Notes.isInvalid],
            ["_ProjectID", [], fields._ProjectID.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Status": <?= $Page->Status->toClientList($Page) ?>,
            "Category": <?= $Page->Category->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojectresultsearch" id="fprojectresultsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projectresult">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav<?= $Page->MultiPages->containerClasses() ?>" id="pages_ProjectresultSearch"><!-- multi-page tabs -->
    <ul class="<?= $Page->MultiPages->navClasses() ?>" role="tablist">
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(1) ?>" data-bs-target="#tab_projectresult1" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_projectresult1" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>"><?= $Page->pageCaption(1) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(2) ?>" data-bs-target="#tab_projectresult2" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_projectresult2" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>"><?= $Page->pageCaption(2) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(3) ?>" data-bs-target="#tab_projectresult3" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_projectresult3" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>"><?= $Page->pageCaption(3) ?></button></li>
    </ul>
    <div class="<?= $Page->MultiPages->tabContentClasses() ?>"><!-- multi-page tabs .tab-content -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(1) ?>" id="tab_projectresult1" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ResultID->Visible) { // ResultID ?>
    <div id="r_ResultID" class="row"<?= $Page->ResultID->rowAttributes() ?>>
        <label for="x_ResultID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_ResultID"><?= $Page->ResultID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ResultID" id="z_ResultID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ResultID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_ResultID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ResultID->getInputTextType() ?>" name="x_ResultID" id="x_ResultID" data-table="projectresult" data-field="x_ResultID" value="<?= $Page->ResultID->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->ResultID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ResultID->formatPattern()) ?>"<?= $Page->ResultID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ResultID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Activities->Visible) { // Activities ?>
    <div id="r_Activities" class="row"<?= $Page->Activities->rowAttributes() ?>>
        <label for="x_Activities" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Activities"><?= $Page->Activities->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Activities" id="z_Activities" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Activities->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_Activities" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Activities->getInputTextType() ?>" name="x_Activities" id="x_Activities" data-table="projectresult" data-field="x_Activities" value="<?= $Page->Activities->EditValue ?>" data-page="1" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->Activities->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Activities->formatPattern()) ?>"<?= $Page->Activities->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Activities->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DateDelivered->Visible) { // DateDelivered ?>
    <div id="r_DateDelivered" class="row"<?= $Page->DateDelivered->rowAttributes() ?>>
        <label for="x_DateDelivered" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_DateDelivered"><?= $Page->DateDelivered->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DateDelivered->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_DateDelivered" id="z_DateDelivered" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->DateDelivered->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->DateDelivered->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projectresult_DateDelivered" class="ew-search-field">
<input type="<?= $Page->DateDelivered->getInputTextType() ?>" name="x_DateDelivered" id="x_DateDelivered" data-table="projectresult" data-field="x_DateDelivered" value="<?= $Page->DateDelivered->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->DateDelivered->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateDelivered->formatPattern()) ?>"<?= $Page->DateDelivered->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateDelivered->getErrorMessage(false) ?></div>
<?php if (!$Page->DateDelivered->ReadOnly && !$Page->DateDelivered->Disabled && !isset($Page->DateDelivered->EditAttrs["readonly"]) && !isset($Page->DateDelivered->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "x_DateDelivered", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projectresult_DateDelivered" class="ew-search-field2 d-none">
<input type="<?= $Page->DateDelivered->getInputTextType() ?>" name="y_DateDelivered" id="y_DateDelivered" data-table="projectresult" data-field="x_DateDelivered" value="<?= $Page->DateDelivered->EditValue2 ?>" data-page="1" placeholder="<?= HtmlEncode($Page->DateDelivered->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateDelivered->formatPattern()) ?>"<?= $Page->DateDelivered->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateDelivered->getErrorMessage(false) ?></div>
<?php if (!$Page->DateDelivered->ReadOnly && !$Page->DateDelivered->Disabled && !isset($Page->DateDelivered->EditAttrs["readonly"]) && !isset($Page->DateDelivered->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "y_DateDelivered", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Progress->Visible) { // Progress ?>
    <div id="r_Progress" class="row"<?= $Page->Progress->rowAttributes() ?>>
        <label for="x_Progress" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Progress"><?= $Page->Progress->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Progress->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Progress" id="z_Progress" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Progress->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Progress->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projectresult_Progress" class="ew-search-field">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="x_Progress" id="x_Progress" data-table="projectresult" data-field="x_Progress" value="<?= $Page->Progress->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projectresult_Progress" class="ew-search-field2 d-none">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="y_Progress" id="y_Progress" data-table="projectresult" data-field="x_Progress" value="<?= $Page->Progress->EditValue2 ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Status->Visible) { // Status ?>
    <div id="r_Status" class="row"<?= $Page->Status->rowAttributes() ?>>
        <label for="x_Status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Status"><?= $Page->Status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Status" id="z_Status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_Status" class="ew-search-field ew-search-field-single">
    <select
        id="x_Status"
        name="x_Status"
        class="form-select ew-select<?= $Page->Status->isInvalidClass() ?>"
        <?php if (!$Page->Status->IsNativeSelect) { ?>
        data-select2-id="fprojectresultsearch_x_Status"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Status"
        data-page="1"
        data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
        <?= $Page->Status->editAttributes() ?>>
        <?= $Page->Status->selectOptionListHtml("x_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Status->getErrorMessage(false) ?></div>
<?= $Page->Status->Lookup->getParamTag($Page, "p_x_Status") ?>
<?php if (!$Page->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultsearch", function() {
    var options = { name: "x_Status", selectId: "fprojectresultsearch_x_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultsearch.lists.Status?.lookupOptions.length) {
        options.data = { id: "x_Status", form: "fprojectresultsearch" };
    } else {
        options.ajax = { id: "x_Status", form: "fprojectresultsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->File->Visible) { // File ?>
    <div id="r_File" class="row"<?= $Page->File->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_File"><?= $Page->File->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_File" id="z_File" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->File->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_File" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->File->getInputTextType() ?>" name="x_File" id="x_File" data-table="projectresult" data-field="x_File" value="<?= $Page->File->EditValue ?>" data-page="1" maxlength="1200" placeholder="<?= HtmlEncode($Page->File->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->File->formatPattern()) ?>"<?= $Page->File->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->File->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Notes->Visible) { // Notes ?>
    <div id="r_Notes" class="row"<?= $Page->Notes->rowAttributes() ?>>
        <label for="x_Notes" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Notes"><?= $Page->Notes->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Notes" id="z_Notes" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Notes->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_Notes" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Notes->getInputTextType() ?>" name="x_Notes" id="x_Notes" data-table="projectresult" data-field="x_Notes" value="<?= $Page->Notes->EditValue ?>" data-page="1" maxlength="1200" placeholder="<?= HtmlEncode($Page->Notes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Notes->formatPattern()) ?>"<?= $Page->Notes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Notes->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(2) ?>" id="tab_projectresult2" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->Category->Visible) { // Category ?>
    <div id="r_Category" class="row"<?= $Page->Category->rowAttributes() ?>>
        <label for="x_Category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Category"><?= $Page->Category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Category" id="z_Category" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_Category" class="ew-search-field ew-search-field-single">
    <select
        id="x_Category"
        name="x_Category"
        class="form-select ew-select<?= $Page->Category->isInvalidClass() ?>"
        <?php if (!$Page->Category->IsNativeSelect) { ?>
        data-select2-id="fprojectresultsearch_x_Category"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Category"
        data-page="2"
        data-value-separator="<?= $Page->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Category->getPlaceHolder()) ?>"
        <?= $Page->Category->editAttributes() ?>>
        <?= $Page->Category->selectOptionListHtml("x_Category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Category->getErrorMessage(false) ?></div>
<?= $Page->Category->Lookup->getParamTag($Page, "p_x_Category") ?>
<?php if (!$Page->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultsearch", function() {
    var options = { name: "x_Category", selectId: "fprojectresultsearch_x_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultsearch.lists.Category?.lookupOptions.length) {
        options.data = { id: "x_Category", form: "fprojectresultsearch" };
    } else {
        options.ajax = { id: "x_Category", form: "fprojectresultsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Weight->Visible) { // Weight ?>
    <div id="r_Weight" class="row"<?= $Page->Weight->rowAttributes() ?>>
        <label for="x_Weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Weight"><?= $Page->Weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Weight" id="z_Weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_Weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Weight->getInputTextType() ?>" name="x_Weight" id="x_Weight" data-table="projectresult" data-field="x_Weight" value="<?= $Page->Weight->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->Weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Weight->formatPattern()) ?>"<?= $Page->Weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
    <div id="r__ProjectID" class="row"<?= $Page->_ProjectID->rowAttributes() ?>>
        <label for="x__ProjectID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult__ProjectID"><?= $Page->_ProjectID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__ProjectID" id="z__ProjectID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_ProjectID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult__ProjectID" class="ew-search-field ew-search-field-single">
    <select
        id="x__ProjectID"
        name="x__ProjectID"
        class="form-select ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectresultsearch_x__ProjectID"
        <?php } ?>
        data-table="projectresult"
        data-field="x__ProjectID"
        data-page="2"
        data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
        <?= $Page->_ProjectID->editAttributes() ?>>
        <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
<?= $Page->_ProjectID->Lookup->getParamTag($Page, "p_x__ProjectID") ?>
<?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultsearch", function() {
    var options = { name: "x__ProjectID", selectId: "fprojectresultsearch_x__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultsearch.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x__ProjectID", form: "fprojectresultsearch" };
    } else {
        options.ajax = { id: "x__ProjectID", form: "fprojectresultsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(3) ?>" id="tab_projectresult3" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
    <div id="r_Created_Date" class="row"<?= $Page->Created_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Created_Date"><?= $Page->Created_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Created_Date" id="z_Created_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Created_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Created_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projectresult_Created_Date" class="ew-search-field">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="projectresult" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projectresult_Created_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="y_Created_Date" id="y_Created_Date" data-table="projectresult" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue2 ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "y_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <div id="r_Created_By" class="row"<?= $Page->Created_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Created_By"><?= $Page->Created_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Created_By" id="z_Created_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="projectresult" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" data-page="3" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
    <div id="r_Last_Updated_Date" class="row"<?= $Page->Last_Updated_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Last_Updated_Date"><?= $Page->Last_Updated_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Last_Updated_Date" id="z_Last_Updated_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Last_Updated_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Last_Updated_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projectresult_Last_Updated_Date" class="ew-search-field">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="projectresult" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projectresult_Last_Updated_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="y_Last_Updated_Date" id="y_Last_Updated_Date" data-table="projectresult" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue2 ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "y_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
    <div id="r_Last_Updated_By" class="row"<?= $Page->Last_Updated_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectresult_Last_Updated_By"><?= $Page->Last_Updated_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Last_Updated_By" id="z_Last_Updated_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectresult_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="projectresult" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" data-page="3" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
    </div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprojectresultsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojectresultsearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprojectresultsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectresult");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
