<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjecttaskGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojecttaskgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projecttask: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojecttaskgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["TaskName", [fields.TaskName.visible && fields.TaskName.required ? ew.Validators.required(fields.TaskName.caption) : null], fields.TaskName.isInvalid],
            ["AssignedTo", [fields.AssignedTo.visible && fields.AssignedTo.required ? ew.Validators.required(fields.AssignedTo.caption) : null], fields.AssignedTo.isInvalid],
            ["Progress", [fields.Progress.visible && fields.Progress.required ? ew.Validators.required(fields.Progress.caption) : null, ew.Validators.float], fields.Progress.isInvalid],
            ["Complete", [fields.Complete.visible && fields.Complete.required ? ew.Validators.required(fields.Complete.caption) : null], fields.Complete.isInvalid],
            ["Target", [fields.Target.visible && fields.Target.required ? ew.Validators.required(fields.Target.caption) : null, ew.Validators.float], fields.Target.isInvalid],
            ["Track", [fields.Track.visible && fields.Track.required ? ew.Validators.required(fields.Track.caption) : null], fields.Track.isInvalid],
            ["PlanStart", [fields.PlanStart.visible && fields.PlanStart.required ? ew.Validators.required(fields.PlanStart.caption) : null, ew.Validators.datetime(fields.PlanStart.clientFormatPattern)], fields.PlanStart.isInvalid],
            ["PlanEnd", [fields.PlanEnd.visible && fields.PlanEnd.required ? ew.Validators.required(fields.PlanEnd.caption) : null, ew.Validators.datetime(fields.PlanEnd.clientFormatPattern)], fields.PlanEnd.isInvalid],
            ["StartDate", [fields.StartDate.visible && fields.StartDate.required ? ew.Validators.required(fields.StartDate.caption) : null, ew.Validators.datetime(fields.StartDate.clientFormatPattern)], fields.StartDate.isInvalid],
            ["EndDate", [fields.EndDate.visible && fields.EndDate.required ? ew.Validators.required(fields.EndDate.caption) : null, ew.Validators.datetime(fields.EndDate.clientFormatPattern)], fields.EndDate.isInvalid],
            ["Priority", [fields.Priority.visible && fields.Priority.required ? ew.Validators.required(fields.Priority.caption) : null], fields.Priority.isInvalid],
            ["Category", [fields.Category.visible && fields.Category.required ? ew.Validators.required(fields.Category.caption) : null], fields.Category.isInvalid],
            ["_ProjectID", [fields._ProjectID.visible && fields._ProjectID.required ? ew.Validators.required(fields._ProjectID.caption) : null], fields._ProjectID.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["TaskName",false],["AssignedTo",false],["Progress",false],["Complete",false],["Target",false],["Track",false],["PlanStart",false],["PlanEnd",false],["StartDate",false],["EndDate",false],["Priority",false],["Category",false],["_ProjectID",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "AssignedTo": <?= $Grid->AssignedTo->toClientList($Grid) ?>,
            "Priority": <?= $Grid->Priority->toClientList($Grid) ?>,
            "Category": <?= $Grid->Category->toClientList($Grid) ?>,
            "_ProjectID": <?= $Grid->_ProjectID->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojecttaskgrid" class="ew-form ew-list-form">
<div id="gmp_projecttask" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projecttaskgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->TaskName->Visible) { // TaskName ?>
        <th data-name="TaskName" class="<?= $Grid->TaskName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_TaskName" class="projecttask_TaskName"><?= $Grid->renderFieldHeader($Grid->TaskName) ?></div></th>
<?php } ?>
<?php if ($Grid->AssignedTo->Visible) { // AssignedTo ?>
        <th data-name="AssignedTo" class="<?= $Grid->AssignedTo->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_AssignedTo" class="projecttask_AssignedTo"><?= $Grid->renderFieldHeader($Grid->AssignedTo) ?></div></th>
<?php } ?>
<?php if ($Grid->Progress->Visible) { // Progress ?>
        <th data-name="Progress" class="<?= $Grid->Progress->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Progress" class="projecttask_Progress"><?= $Grid->renderFieldHeader($Grid->Progress) ?></div></th>
<?php } ?>
<?php if ($Grid->Complete->Visible) { // Complete ?>
        <th data-name="Complete" class="<?= $Grid->Complete->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Complete" class="projecttask_Complete"><?= $Grid->renderFieldHeader($Grid->Complete) ?></div></th>
<?php } ?>
<?php if ($Grid->Target->Visible) { // Target ?>
        <th data-name="Target" class="<?= $Grid->Target->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Target" class="projecttask_Target"><?= $Grid->renderFieldHeader($Grid->Target) ?></div></th>
<?php } ?>
<?php if ($Grid->Track->Visible) { // Track ?>
        <th data-name="Track" class="<?= $Grid->Track->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Track" class="projecttask_Track"><?= $Grid->renderFieldHeader($Grid->Track) ?></div></th>
<?php } ?>
<?php if ($Grid->PlanStart->Visible) { // PlanStart ?>
        <th data-name="PlanStart" class="<?= $Grid->PlanStart->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_PlanStart" class="projecttask_PlanStart"><?= $Grid->renderFieldHeader($Grid->PlanStart) ?></div></th>
<?php } ?>
<?php if ($Grid->PlanEnd->Visible) { // PlanEnd ?>
        <th data-name="PlanEnd" class="<?= $Grid->PlanEnd->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_PlanEnd" class="projecttask_PlanEnd"><?= $Grid->renderFieldHeader($Grid->PlanEnd) ?></div></th>
<?php } ?>
<?php if ($Grid->StartDate->Visible) { // StartDate ?>
        <th data-name="StartDate" class="<?= $Grid->StartDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_StartDate" class="projecttask_StartDate"><?= $Grid->renderFieldHeader($Grid->StartDate) ?></div></th>
<?php } ?>
<?php if ($Grid->EndDate->Visible) { // EndDate ?>
        <th data-name="EndDate" class="<?= $Grid->EndDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_EndDate" class="projecttask_EndDate"><?= $Grid->renderFieldHeader($Grid->EndDate) ?></div></th>
<?php } ?>
<?php if ($Grid->Priority->Visible) { // Priority ?>
        <th data-name="Priority" class="<?= $Grid->Priority->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Priority" class="projecttask_Priority"><?= $Grid->renderFieldHeader($Grid->Priority) ?></div></th>
<?php } ?>
<?php if ($Grid->Category->Visible) { // Category ?>
        <th data-name="Category" class="<?= $Grid->Category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Category" class="projecttask_Category"><?= $Grid->renderFieldHeader($Grid->Category) ?></div></th>
<?php } ?>
<?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Grid->_ProjectID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask__ProjectID" class="projecttask__ProjectID"><?= $Grid->renderFieldHeader($Grid->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Created_Date" class="projecttask_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Created_By" class="projecttask_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Last_Updated_Date" class="projecttask_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Last_Updated_By" class="projecttask_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->TaskName->Visible) { // TaskName ?>
        <td data-name="TaskName"<?= $Grid->TaskName->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_TaskName" class="el_projecttask_TaskName">
<input type="<?= $Grid->TaskName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TaskName" id="x<?= $Grid->RowIndex ?>_TaskName" data-table="projecttask" data-field="x_TaskName" value="<?= $Grid->TaskName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Grid->TaskName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TaskName->formatPattern()) ?>"<?= $Grid->TaskName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TaskName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttask" data-field="x_TaskName" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TaskName" id="o<?= $Grid->RowIndex ?>_TaskName" value="<?= HtmlEncode($Grid->TaskName->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_TaskName" class="el_projecttask_TaskName">
<input type="<?= $Grid->TaskName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TaskName" id="x<?= $Grid->RowIndex ?>_TaskName" data-table="projecttask" data-field="x_TaskName" value="<?= $Grid->TaskName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Grid->TaskName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TaskName->formatPattern()) ?>"<?= $Grid->TaskName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TaskName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_TaskName" class="el_projecttask_TaskName">
<span<?= $Grid->TaskName->viewAttributes() ?>>
<?= $Grid->TaskName->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_TaskName" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_TaskName" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_TaskName" value="<?= HtmlEncode($Grid->TaskName->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_TaskName" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_TaskName" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_TaskName" value="<?= HtmlEncode($Grid->TaskName->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->AssignedTo->Visible) { // AssignedTo ?>
        <td data-name="AssignedTo"<?= $Grid->AssignedTo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_AssignedTo" class="el_projecttask_AssignedTo">
    <select
        id="x<?= $Grid->RowIndex ?>_AssignedTo"
        name="x<?= $Grid->RowIndex ?>_AssignedTo"
        class="form-select ew-select<?= $Grid->AssignedTo->isInvalidClass() ?>"
        <?php if (!$Grid->AssignedTo->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>_AssignedTo"
        <?php } ?>
        data-table="projecttask"
        data-field="x_AssignedTo"
        data-value-separator="<?= $Grid->AssignedTo->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->AssignedTo->getPlaceHolder()) ?>"
        <?= $Grid->AssignedTo->editAttributes() ?>>
        <?= $Grid->AssignedTo->selectOptionListHtml("x{$Grid->RowIndex}_AssignedTo") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->AssignedTo->getErrorMessage() ?></div>
<?= $Grid->AssignedTo->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_AssignedTo") ?>
<?php if (!$Grid->AssignedTo->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_AssignedTo", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>_AssignedTo" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists.AssignedTo?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_AssignedTo", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_AssignedTo", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.AssignedTo.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttask" data-field="x_AssignedTo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_AssignedTo" id="o<?= $Grid->RowIndex ?>_AssignedTo" value="<?= HtmlEncode($Grid->AssignedTo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_AssignedTo" class="el_projecttask_AssignedTo">
    <select
        id="x<?= $Grid->RowIndex ?>_AssignedTo"
        name="x<?= $Grid->RowIndex ?>_AssignedTo"
        class="form-select ew-select<?= $Grid->AssignedTo->isInvalidClass() ?>"
        <?php if (!$Grid->AssignedTo->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>_AssignedTo"
        <?php } ?>
        data-table="projecttask"
        data-field="x_AssignedTo"
        data-value-separator="<?= $Grid->AssignedTo->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->AssignedTo->getPlaceHolder()) ?>"
        <?= $Grid->AssignedTo->editAttributes() ?>>
        <?= $Grid->AssignedTo->selectOptionListHtml("x{$Grid->RowIndex}_AssignedTo") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->AssignedTo->getErrorMessage() ?></div>
<?= $Grid->AssignedTo->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_AssignedTo") ?>
<?php if (!$Grid->AssignedTo->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_AssignedTo", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>_AssignedTo" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists.AssignedTo?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_AssignedTo", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_AssignedTo", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.AssignedTo.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_AssignedTo" class="el_projecttask_AssignedTo">
<span<?= $Grid->AssignedTo->viewAttributes() ?>>
<?= $Grid->AssignedTo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_AssignedTo" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_AssignedTo" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_AssignedTo" value="<?= HtmlEncode($Grid->AssignedTo->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_AssignedTo" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_AssignedTo" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_AssignedTo" value="<?= HtmlEncode($Grid->AssignedTo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Progress->Visible) { // Progress ?>
        <td data-name="Progress"<?= $Grid->Progress->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Progress" class="el_projecttask_Progress">
<input type="<?= $Grid->Progress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Progress" id="x<?= $Grid->RowIndex ?>_Progress" data-table="projecttask" data-field="x_Progress" value="<?= $Grid->Progress->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Progress->formatPattern()) ?>"<?= $Grid->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Progress->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttask" data-field="x_Progress" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Progress" id="o<?= $Grid->RowIndex ?>_Progress" value="<?= HtmlEncode($Grid->Progress->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Progress" class="el_projecttask_Progress">
<input type="<?= $Grid->Progress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Progress" id="x<?= $Grid->RowIndex ?>_Progress" data-table="projecttask" data-field="x_Progress" value="<?= $Grid->Progress->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Progress->formatPattern()) ?>"<?= $Grid->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Progress->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Progress" class="el_projecttask_Progress">
<span<?= $Grid->Progress->viewAttributes() ?>>
<?= $Grid->Progress->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Progress" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Progress" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Progress" value="<?= HtmlEncode($Grid->Progress->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Progress" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Progress" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Progress" value="<?= HtmlEncode($Grid->Progress->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Complete->Visible) { // Complete ?>
        <td data-name="Complete"<?= $Grid->Complete->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Complete" class="el_projecttask_Complete">
<input type="<?= $Grid->Complete->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Complete" id="x<?= $Grid->RowIndex ?>_Complete" data-table="projecttask" data-field="x_Complete" value="<?= $Grid->Complete->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->Complete->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Complete->formatPattern()) ?>"<?= $Grid->Complete->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Complete->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttask" data-field="x_Complete" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Complete" id="o<?= $Grid->RowIndex ?>_Complete" value="<?= HtmlEncode($Grid->Complete->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Complete" class="el_projecttask_Complete">
<input type="<?= $Grid->Complete->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Complete" id="x<?= $Grid->RowIndex ?>_Complete" data-table="projecttask" data-field="x_Complete" value="<?= $Grid->Complete->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->Complete->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Complete->formatPattern()) ?>"<?= $Grid->Complete->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Complete->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Complete" class="el_projecttask_Complete">
<span<?= $Grid->Complete->viewAttributes() ?>>
<?= $Grid->Complete->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Complete" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Complete" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Complete" value="<?= HtmlEncode($Grid->Complete->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Complete" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Complete" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Complete" value="<?= HtmlEncode($Grid->Complete->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Target->Visible) { // Target ?>
        <td data-name="Target"<?= $Grid->Target->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Target" class="el_projecttask_Target">
<input type="<?= $Grid->Target->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Target" id="x<?= $Grid->RowIndex ?>_Target" data-table="projecttask" data-field="x_Target" value="<?= $Grid->Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Target->formatPattern()) ?>"<?= $Grid->Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Target->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttask" data-field="x_Target" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Target" id="o<?= $Grid->RowIndex ?>_Target" value="<?= HtmlEncode($Grid->Target->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Target" class="el_projecttask_Target">
<input type="<?= $Grid->Target->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Target" id="x<?= $Grid->RowIndex ?>_Target" data-table="projecttask" data-field="x_Target" value="<?= $Grid->Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Target->formatPattern()) ?>"<?= $Grid->Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Target->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Target" class="el_projecttask_Target">
<span<?= $Grid->Target->viewAttributes() ?>>
<?= $Grid->Target->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Target" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Target" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Target" value="<?= HtmlEncode($Grid->Target->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Target" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Target" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Target" value="<?= HtmlEncode($Grid->Target->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Track->Visible) { // Track ?>
        <td data-name="Track"<?= $Grid->Track->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Track" class="el_projecttask_Track">
<input type="<?= $Grid->Track->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Track" id="x<?= $Grid->RowIndex ?>_Track" data-table="projecttask" data-field="x_Track" value="<?= $Grid->Track->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Grid->Track->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Track->formatPattern()) ?>"<?= $Grid->Track->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Track->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttask" data-field="x_Track" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Track" id="o<?= $Grid->RowIndex ?>_Track" value="<?= HtmlEncode($Grid->Track->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Track" class="el_projecttask_Track">
<input type="<?= $Grid->Track->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Track" id="x<?= $Grid->RowIndex ?>_Track" data-table="projecttask" data-field="x_Track" value="<?= $Grid->Track->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Grid->Track->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Track->formatPattern()) ?>"<?= $Grid->Track->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Track->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Track" class="el_projecttask_Track">
<span<?= $Grid->Track->viewAttributes() ?>>
<?= $Grid->Track->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Track" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Track" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Track" value="<?= HtmlEncode($Grid->Track->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Track" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Track" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Track" value="<?= HtmlEncode($Grid->Track->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PlanStart->Visible) { // PlanStart ?>
        <td data-name="PlanStart"<?= $Grid->PlanStart->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_PlanStart" class="el_projecttask_PlanStart">
<input type="<?= $Grid->PlanStart->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlanStart" id="x<?= $Grid->RowIndex ?>_PlanStart" data-table="projecttask" data-field="x_PlanStart" value="<?= $Grid->PlanStart->EditValue ?>" placeholder="<?= HtmlEncode($Grid->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlanStart->formatPattern()) ?>"<?= $Grid->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlanStart->getErrorMessage() ?></div>
<?php if (!$Grid->PlanStart->ReadOnly && !$Grid->PlanStart->Disabled && !isset($Grid->PlanStart->EditAttrs["readonly"]) && !isset($Grid->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttask" data-field="x_PlanStart" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PlanStart" id="o<?= $Grid->RowIndex ?>_PlanStart" value="<?= HtmlEncode($Grid->PlanStart->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_PlanStart" class="el_projecttask_PlanStart">
<input type="<?= $Grid->PlanStart->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlanStart" id="x<?= $Grid->RowIndex ?>_PlanStart" data-table="projecttask" data-field="x_PlanStart" value="<?= $Grid->PlanStart->EditValue ?>" placeholder="<?= HtmlEncode($Grid->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlanStart->formatPattern()) ?>"<?= $Grid->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlanStart->getErrorMessage() ?></div>
<?php if (!$Grid->PlanStart->ReadOnly && !$Grid->PlanStart->Disabled && !isset($Grid->PlanStart->EditAttrs["readonly"]) && !isset($Grid->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_PlanStart" class="el_projecttask_PlanStart">
<span<?= $Grid->PlanStart->viewAttributes() ?>>
<?= $Grid->PlanStart->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_PlanStart" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_PlanStart" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_PlanStart" value="<?= HtmlEncode($Grid->PlanStart->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_PlanStart" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_PlanStart" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_PlanStart" value="<?= HtmlEncode($Grid->PlanStart->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PlanEnd->Visible) { // PlanEnd ?>
        <td data-name="PlanEnd"<?= $Grid->PlanEnd->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_PlanEnd" class="el_projecttask_PlanEnd">
<input type="<?= $Grid->PlanEnd->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlanEnd" id="x<?= $Grid->RowIndex ?>_PlanEnd" data-table="projecttask" data-field="x_PlanEnd" value="<?= $Grid->PlanEnd->EditValue ?>" placeholder="<?= HtmlEncode($Grid->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlanEnd->formatPattern()) ?>"<?= $Grid->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlanEnd->getErrorMessage() ?></div>
<?php if (!$Grid->PlanEnd->ReadOnly && !$Grid->PlanEnd->Disabled && !isset($Grid->PlanEnd->EditAttrs["readonly"]) && !isset($Grid->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttask" data-field="x_PlanEnd" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PlanEnd" id="o<?= $Grid->RowIndex ?>_PlanEnd" value="<?= HtmlEncode($Grid->PlanEnd->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_PlanEnd" class="el_projecttask_PlanEnd">
<input type="<?= $Grid->PlanEnd->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlanEnd" id="x<?= $Grid->RowIndex ?>_PlanEnd" data-table="projecttask" data-field="x_PlanEnd" value="<?= $Grid->PlanEnd->EditValue ?>" placeholder="<?= HtmlEncode($Grid->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlanEnd->formatPattern()) ?>"<?= $Grid->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlanEnd->getErrorMessage() ?></div>
<?php if (!$Grid->PlanEnd->ReadOnly && !$Grid->PlanEnd->Disabled && !isset($Grid->PlanEnd->EditAttrs["readonly"]) && !isset($Grid->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_PlanEnd" class="el_projecttask_PlanEnd">
<span<?= $Grid->PlanEnd->viewAttributes() ?>>
<?= $Grid->PlanEnd->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_PlanEnd" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_PlanEnd" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_PlanEnd" value="<?= HtmlEncode($Grid->PlanEnd->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_PlanEnd" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_PlanEnd" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_PlanEnd" value="<?= HtmlEncode($Grid->PlanEnd->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->StartDate->Visible) { // StartDate ?>
        <td data-name="StartDate"<?= $Grid->StartDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_StartDate" class="el_projecttask_StartDate">
<input type="<?= $Grid->StartDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_StartDate" id="x<?= $Grid->RowIndex ?>_StartDate" data-table="projecttask" data-field="x_StartDate" value="<?= $Grid->StartDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->StartDate->formatPattern()) ?>"<?= $Grid->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->StartDate->getErrorMessage() ?></div>
<?php if (!$Grid->StartDate->ReadOnly && !$Grid->StartDate->Disabled && !isset($Grid->StartDate->EditAttrs["readonly"]) && !isset($Grid->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttask" data-field="x_StartDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_StartDate" id="o<?= $Grid->RowIndex ?>_StartDate" value="<?= HtmlEncode($Grid->StartDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_StartDate" class="el_projecttask_StartDate">
<input type="<?= $Grid->StartDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_StartDate" id="x<?= $Grid->RowIndex ?>_StartDate" data-table="projecttask" data-field="x_StartDate" value="<?= $Grid->StartDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->StartDate->formatPattern()) ?>"<?= $Grid->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->StartDate->getErrorMessage() ?></div>
<?php if (!$Grid->StartDate->ReadOnly && !$Grid->StartDate->Disabled && !isset($Grid->StartDate->EditAttrs["readonly"]) && !isset($Grid->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_StartDate" class="el_projecttask_StartDate">
<span<?= $Grid->StartDate->viewAttributes() ?>>
<?= $Grid->StartDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_StartDate" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_StartDate" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_StartDate" value="<?= HtmlEncode($Grid->StartDate->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_StartDate" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_StartDate" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_StartDate" value="<?= HtmlEncode($Grid->StartDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->EndDate->Visible) { // EndDate ?>
        <td data-name="EndDate"<?= $Grid->EndDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_EndDate" class="el_projecttask_EndDate">
<input type="<?= $Grid->EndDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_EndDate" id="x<?= $Grid->RowIndex ?>_EndDate" data-table="projecttask" data-field="x_EndDate" value="<?= $Grid->EndDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->EndDate->formatPattern()) ?>"<?= $Grid->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->EndDate->getErrorMessage() ?></div>
<?php if (!$Grid->EndDate->ReadOnly && !$Grid->EndDate->Disabled && !isset($Grid->EndDate->EditAttrs["readonly"]) && !isset($Grid->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttask" data-field="x_EndDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_EndDate" id="o<?= $Grid->RowIndex ?>_EndDate" value="<?= HtmlEncode($Grid->EndDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_EndDate" class="el_projecttask_EndDate">
<input type="<?= $Grid->EndDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_EndDate" id="x<?= $Grid->RowIndex ?>_EndDate" data-table="projecttask" data-field="x_EndDate" value="<?= $Grid->EndDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->EndDate->formatPattern()) ?>"<?= $Grid->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->EndDate->getErrorMessage() ?></div>
<?php if (!$Grid->EndDate->ReadOnly && !$Grid->EndDate->Disabled && !isset($Grid->EndDate->EditAttrs["readonly"]) && !isset($Grid->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttaskgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttaskgrid", "x<?= $Grid->RowIndex ?>_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_EndDate" class="el_projecttask_EndDate">
<span<?= $Grid->EndDate->viewAttributes() ?>>
<?= $Grid->EndDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_EndDate" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_EndDate" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_EndDate" value="<?= HtmlEncode($Grid->EndDate->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_EndDate" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_EndDate" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_EndDate" value="<?= HtmlEncode($Grid->EndDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Priority->Visible) { // Priority ?>
        <td data-name="Priority"<?= $Grid->Priority->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Priority" class="el_projecttask_Priority">
    <select
        id="x<?= $Grid->RowIndex ?>_Priority"
        name="x<?= $Grid->RowIndex ?>_Priority"
        class="form-select ew-select<?= $Grid->Priority->isInvalidClass() ?>"
        <?php if (!$Grid->Priority->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Priority"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Priority"
        data-value-separator="<?= $Grid->Priority->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Priority->getPlaceHolder()) ?>"
        <?= $Grid->Priority->editAttributes() ?>>
        <?= $Grid->Priority->selectOptionListHtml("x{$Grid->RowIndex}_Priority") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Priority->getErrorMessage() ?></div>
<?php if (!$Grid->Priority->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Priority", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Priority" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists.Priority?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Priority", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Priority", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Priority.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttask" data-field="x_Priority" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Priority" id="o<?= $Grid->RowIndex ?>_Priority" value="<?= HtmlEncode($Grid->Priority->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Priority" class="el_projecttask_Priority">
    <select
        id="x<?= $Grid->RowIndex ?>_Priority"
        name="x<?= $Grid->RowIndex ?>_Priority"
        class="form-select ew-select<?= $Grid->Priority->isInvalidClass() ?>"
        <?php if (!$Grid->Priority->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Priority"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Priority"
        data-value-separator="<?= $Grid->Priority->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Priority->getPlaceHolder()) ?>"
        <?= $Grid->Priority->editAttributes() ?>>
        <?= $Grid->Priority->selectOptionListHtml("x{$Grid->RowIndex}_Priority") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Priority->getErrorMessage() ?></div>
<?php if (!$Grid->Priority->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Priority", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Priority" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists.Priority?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Priority", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Priority", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Priority.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Priority" class="el_projecttask_Priority">
<span<?= $Grid->Priority->viewAttributes() ?>>
<?= $Grid->Priority->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Priority" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Priority" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Priority" value="<?= HtmlEncode($Grid->Priority->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Priority" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Priority" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Priority" value="<?= HtmlEncode($Grid->Priority->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Category->Visible) { // Category ?>
        <td data-name="Category"<?= $Grid->Category->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Category" class="el_projecttask_Category">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_Category"
        name="x<?= $Grid->RowIndex ?>_Category"
        class="form-select ew-select<?= $Grid->Category->isInvalidClass() ?>"
        <?php if (!$Grid->Category->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Category"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Category"
        data-value-separator="<?= $Grid->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Category->getPlaceHolder()) ?>"
        <?= $Grid->Category->editAttributes() ?>>
        <?= $Grid->Category->selectOptionListHtml("x{$Grid->RowIndex}_Category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterprojectcategory") && !$Grid->Category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_Category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->Category->caption() ?>" data-title="<?= $Grid->Category->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_Category" data-url="<?= GetUrl("masterprojectcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->Category->getErrorMessage() ?></div>
<?= $Grid->Category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Category") ?>
<?php if (!$Grid->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Category", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists.Category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttask" data-field="x_Category" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Category" id="o<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Category" class="el_projecttask_Category">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_Category"
        name="x<?= $Grid->RowIndex ?>_Category"
        class="form-select ew-select<?= $Grid->Category->isInvalidClass() ?>"
        <?php if (!$Grid->Category->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Category"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Category"
        data-value-separator="<?= $Grid->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Category->getPlaceHolder()) ?>"
        <?= $Grid->Category->editAttributes() ?>>
        <?= $Grid->Category->selectOptionListHtml("x{$Grid->RowIndex}_Category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterprojectcategory") && !$Grid->Category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_Category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->Category->caption() ?>" data-title="<?= $Grid->Category->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_Category" data-url="<?= GetUrl("masterprojectcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->Category->getErrorMessage() ?></div>
<?= $Grid->Category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Category") ?>
<?php if (!$Grid->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Category", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists.Category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Category" class="el_projecttask_Category">
<span<?= $Grid->Category->viewAttributes() ?>>
<?= $Grid->Category->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Category" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Category" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Category" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Category" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Grid->_ProjectID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask__ProjectID" class="el_projecttask__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projecttask"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projecttask" data-field="x__ProjectID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__ProjectID" id="o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask__ProjectID" class="el_projecttask__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojecttaskgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projecttask"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttaskgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojecttaskgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttaskgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojecttaskgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojecttaskgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask__ProjectID" class="el_projecttask__ProjectID">
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<?= $Grid->_ProjectID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x__ProjectID" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>__ProjectID" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x__ProjectID" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>__ProjectID" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Created_Date" class="el_projecttask_Created_Date">
<input type="hidden" data-table="projecttask" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projecttask" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Created_Date" class="el_projecttask_Created_Date">
<input type="hidden" data-table="projecttask" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Created_Date" class="el_projecttask_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Created_Date" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Created_Date" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Created_By" class="el_projecttask_Created_By">
<input type="hidden" data-table="projecttask" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projecttask" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Created_By" class="el_projecttask_Created_By">
<input type="hidden" data-table="projecttask" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Created_By" class="el_projecttask_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Created_By" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Created_By" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projecttask" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Last_Updated_Date" class="el_projecttask_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projecttask" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttask_Last_Updated_By" class="el_projecttask_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttask" data-field="x_Last_Updated_By" data-hidden="1" name="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojecttaskgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projecttask" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojecttaskgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojecttaskgrid","load"], () => fprojecttaskgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->TaskName->Visible) { // TaskName ?>
        <td data-name="TaskName" class="<?= $Grid->TaskName->footerCellClass() ?>"><span id="elf_projecttask_TaskName" class="projecttask_TaskName">
        </span></td>
    <?php } ?>
    <?php if ($Grid->AssignedTo->Visible) { // AssignedTo ?>
        <td data-name="AssignedTo" class="<?= $Grid->AssignedTo->footerCellClass() ?>"><span id="elf_projecttask_AssignedTo" class="projecttask_AssignedTo">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Progress->Visible) { // Progress ?>
        <td data-name="Progress" class="<?= $Grid->Progress->footerCellClass() ?>"><span id="elf_projecttask_Progress" class="projecttask_Progress">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Grid->Progress->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->Complete->Visible) { // Complete ?>
        <td data-name="Complete" class="<?= $Grid->Complete->footerCellClass() ?>"><span id="elf_projecttask_Complete" class="projecttask_Complete">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Target->Visible) { // Target ?>
        <td data-name="Target" class="<?= $Grid->Target->footerCellClass() ?>"><span id="elf_projecttask_Target" class="projecttask_Target">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Track->Visible) { // Track ?>
        <td data-name="Track" class="<?= $Grid->Track->footerCellClass() ?>"><span id="elf_projecttask_Track" class="projecttask_Track">
        </span></td>
    <?php } ?>
    <?php if ($Grid->PlanStart->Visible) { // PlanStart ?>
        <td data-name="PlanStart" class="<?= $Grid->PlanStart->footerCellClass() ?>"><span id="elf_projecttask_PlanStart" class="projecttask_PlanStart">
        </span></td>
    <?php } ?>
    <?php if ($Grid->PlanEnd->Visible) { // PlanEnd ?>
        <td data-name="PlanEnd" class="<?= $Grid->PlanEnd->footerCellClass() ?>"><span id="elf_projecttask_PlanEnd" class="projecttask_PlanEnd">
        </span></td>
    <?php } ?>
    <?php if ($Grid->StartDate->Visible) { // StartDate ?>
        <td data-name="StartDate" class="<?= $Grid->StartDate->footerCellClass() ?>"><span id="elf_projecttask_StartDate" class="projecttask_StartDate">
        </span></td>
    <?php } ?>
    <?php if ($Grid->EndDate->Visible) { // EndDate ?>
        <td data-name="EndDate" class="<?= $Grid->EndDate->footerCellClass() ?>"><span id="elf_projecttask_EndDate" class="projecttask_EndDate">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Priority->Visible) { // Priority ?>
        <td data-name="Priority" class="<?= $Grid->Priority->footerCellClass() ?>"><span id="elf_projecttask_Priority" class="projecttask_Priority">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Category->Visible) { // Category ?>
        <td data-name="Category" class="<?= $Grid->Category->footerCellClass() ?>"><span id="elf_projecttask_Category" class="projecttask_Category">
        </span></td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID" class="<?= $Grid->_ProjectID->footerCellClass() ?>"><span id="elf_projecttask__ProjectID" class="projecttask__ProjectID">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date" class="<?= $Grid->Created_Date->footerCellClass() ?>"><span id="elf_projecttask_Created_Date" class="projecttask_Created_Date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By" class="<?= $Grid->Created_By->footerCellClass() ?>"><span id="elf_projecttask_Created_By" class="projecttask_Created_By">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->footerCellClass() ?>"><span id="elf_projecttask_Last_Updated_Date" class="projecttask_Last_Updated_Date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->footerCellClass() ?>"><span id="elf_projecttask_Last_Updated_By" class="projecttask_Last_Updated_By">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojecttaskgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttask");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
