<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjecttemplatepaymentprocessGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojecttemplatepaymentprocessgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projecttemplatepaymentprocess: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojecttemplatepaymentprocessgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["DocumentName", [fields.DocumentName.visible && fields.DocumentName.required ? ew.Validators.required(fields.DocumentName.caption) : null], fields.DocumentName.isInvalid],
            ["PICClient", [fields.PICClient.visible && fields.PICClient.required ? ew.Validators.required(fields.PICClient.caption) : null], fields.PICClient.isInvalid],
            ["FileName", [fields.FileName.visible && fields.FileName.required ? ew.Validators.fileRequired(fields.FileName.caption) : null], fields.FileName.isInvalid],
            ["templateid", [fields.templateid.visible && fields.templateid.required ? ew.Validators.required(fields.templateid.caption) : null], fields.templateid.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["DocumentName",false],["PICClient",false],["FileName",false],["templateid",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "PICClient": <?= $Grid->PICClient->toClientList($Grid) ?>,
            "templateid": <?= $Grid->templateid->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojecttemplatepaymentprocessgrid" class="ew-form ew-list-form">
<div id="gmp_projecttemplatepaymentprocess" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projecttemplatepaymentprocessgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->DocumentName->Visible) { // DocumentName ?>
        <th data-name="DocumentName" class="<?= $Grid->DocumentName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_DocumentName" class="projecttemplatepaymentprocess_DocumentName"><?= $Grid->renderFieldHeader($Grid->DocumentName) ?></div></th>
<?php } ?>
<?php if ($Grid->PICClient->Visible) { // PICClient ?>
        <th data-name="PICClient" class="<?= $Grid->PICClient->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_PICClient" class="projecttemplatepaymentprocess_PICClient"><?= $Grid->renderFieldHeader($Grid->PICClient) ?></div></th>
<?php } ?>
<?php if ($Grid->FileName->Visible) { // FileName ?>
        <th data-name="FileName" class="<?= $Grid->FileName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_FileName" class="projecttemplatepaymentprocess_FileName"><?= $Grid->renderFieldHeader($Grid->FileName) ?></div></th>
<?php } ?>
<?php if ($Grid->templateid->Visible) { // templateid ?>
        <th data-name="templateid" class="<?= $Grid->templateid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_templateid" class="projecttemplatepaymentprocess_templateid"><?= $Grid->renderFieldHeader($Grid->templateid) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_Created_Date" class="projecttemplatepaymentprocess_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_Created_By" class="projecttemplatepaymentprocess_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_Last_Updated_Date" class="projecttemplatepaymentprocess_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplatepaymentprocess_Last_Updated_By" class="projecttemplatepaymentprocess_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->DocumentName->Visible) { // DocumentName ?>
        <td data-name="DocumentName"<?= $Grid->DocumentName->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_DocumentName" class="el_projecttemplatepaymentprocess_DocumentName">
<input type="<?= $Grid->DocumentName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DocumentName" id="x<?= $Grid->RowIndex ?>_DocumentName" data-table="projecttemplatepaymentprocess" data-field="x_DocumentName" value="<?= $Grid->DocumentName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Grid->DocumentName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DocumentName->formatPattern()) ?>"<?= $Grid->DocumentName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DocumentName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_DocumentName" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DocumentName" id="o<?= $Grid->RowIndex ?>_DocumentName" value="<?= HtmlEncode($Grid->DocumentName->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_DocumentName" class="el_projecttemplatepaymentprocess_DocumentName">
<input type="<?= $Grid->DocumentName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DocumentName" id="x<?= $Grid->RowIndex ?>_DocumentName" data-table="projecttemplatepaymentprocess" data-field="x_DocumentName" value="<?= $Grid->DocumentName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Grid->DocumentName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DocumentName->formatPattern()) ?>"<?= $Grid->DocumentName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DocumentName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_DocumentName" class="el_projecttemplatepaymentprocess_DocumentName">
<span<?= $Grid->DocumentName->viewAttributes() ?>>
<?= $Grid->DocumentName->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_DocumentName" data-hidden="1" name="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_DocumentName" id="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_DocumentName" value="<?= HtmlEncode($Grid->DocumentName->FormValue) ?>">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_DocumentName" data-hidden="1" data-old name="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_DocumentName" id="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_DocumentName" value="<?= HtmlEncode($Grid->DocumentName->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PICClient->Visible) { // PICClient ?>
        <td data-name="PICClient"<?= $Grid->PICClient->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_PICClient" class="el_projecttemplatepaymentprocess_PICClient">
    <select
        id="x<?= $Grid->RowIndex ?>_PICClient"
        name="x<?= $Grid->RowIndex ?>_PICClient"
        class="form-select ew-select<?= $Grid->PICClient->isInvalidClass() ?>"
        <?php if (!$Grid->PICClient->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_PICClient"
        <?php } ?>
        data-table="projecttemplatepaymentprocess"
        data-field="x_PICClient"
        data-value-separator="<?= $Grid->PICClient->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->PICClient->getPlaceHolder()) ?>"
        <?= $Grid->PICClient->editAttributes() ?>>
        <?= $Grid->PICClient->selectOptionListHtml("x{$Grid->RowIndex}_PICClient") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->PICClient->getErrorMessage() ?></div>
<?= $Grid->PICClient->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_PICClient") ?>
<?php if (!$Grid->PICClient->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplatepaymentprocessgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_PICClient", selectId: "fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_PICClient" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplatepaymentprocessgrid.lists.PICClient?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_PICClient", form: "fprojecttemplatepaymentprocessgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_PICClient", form: "fprojecttemplatepaymentprocessgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplatepaymentprocess.fields.PICClient.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_PICClient" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PICClient" id="o<?= $Grid->RowIndex ?>_PICClient" value="<?= HtmlEncode($Grid->PICClient->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_PICClient" class="el_projecttemplatepaymentprocess_PICClient">
    <select
        id="x<?= $Grid->RowIndex ?>_PICClient"
        name="x<?= $Grid->RowIndex ?>_PICClient"
        class="form-select ew-select<?= $Grid->PICClient->isInvalidClass() ?>"
        <?php if (!$Grid->PICClient->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_PICClient"
        <?php } ?>
        data-table="projecttemplatepaymentprocess"
        data-field="x_PICClient"
        data-value-separator="<?= $Grid->PICClient->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->PICClient->getPlaceHolder()) ?>"
        <?= $Grid->PICClient->editAttributes() ?>>
        <?= $Grid->PICClient->selectOptionListHtml("x{$Grid->RowIndex}_PICClient") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->PICClient->getErrorMessage() ?></div>
<?= $Grid->PICClient->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_PICClient") ?>
<?php if (!$Grid->PICClient->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplatepaymentprocessgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_PICClient", selectId: "fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_PICClient" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplatepaymentprocessgrid.lists.PICClient?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_PICClient", form: "fprojecttemplatepaymentprocessgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_PICClient", form: "fprojecttemplatepaymentprocessgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplatepaymentprocess.fields.PICClient.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_PICClient" class="el_projecttemplatepaymentprocess_PICClient">
<span<?= $Grid->PICClient->viewAttributes() ?>>
<?= $Grid->PICClient->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_PICClient" data-hidden="1" name="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_PICClient" id="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_PICClient" value="<?= HtmlEncode($Grid->PICClient->FormValue) ?>">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_PICClient" data-hidden="1" data-old name="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_PICClient" id="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_PICClient" value="<?= HtmlEncode($Grid->PICClient->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FileName->Visible) { // FileName ?>
        <td data-name="FileName"<?= $Grid->FileName->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_projecttemplatepaymentprocess_FileName" class="el_projecttemplatepaymentprocess_FileName">
<div id="fd_x<?= $Grid->RowIndex ?>_FileName" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_FileName"
        name="x<?= $Grid->RowIndex ?>_FileName"
        class="form-control ew-file-input"
        title="<?= $Grid->FileName->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplatepaymentprocess"
        data-field="x_FileName"
        data-size="500"
        data-accept-file-types="<?= $Grid->FileName->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->FileName->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->FileName->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->FileName->ReadOnly || $Grid->FileName->Disabled) ? " disabled" : "" ?>
        <?= $Grid->FileName->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->FileName->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_FileName" id= "fn_x<?= $Grid->RowIndex ?>_FileName" value="<?= $Grid->FileName->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_FileName" id= "fa_x<?= $Grid->RowIndex ?>_FileName" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_FileName" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_projecttemplatepaymentprocess_FileName" class="el_projecttemplatepaymentprocess_FileName">
<div id="fd_x<?= $Grid->RowIndex ?>_FileName">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_FileName"
        name="x<?= $Grid->RowIndex ?>_FileName"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->FileName->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplatepaymentprocess"
        data-field="x_FileName"
        data-size="500"
        data-accept-file-types="<?= $Grid->FileName->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->FileName->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->FileName->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->FileName->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->FileName->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_FileName" id= "fn_x<?= $Grid->RowIndex ?>_FileName" value="<?= $Grid->FileName->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_FileName" id= "fa_x<?= $Grid->RowIndex ?>_FileName" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_FileName" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_FileName" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FileName" id="o<?= $Grid->RowIndex ?>_FileName" value="<?= HtmlEncode($Grid->FileName->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_FileName" class="el_projecttemplatepaymentprocess_FileName">
<span<?= $Grid->FileName->viewAttributes() ?>>
<?= GetFileViewTag($Grid->FileName, $Grid->FileName->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_FileName" class="el_projecttemplatepaymentprocess_FileName">
<div id="fd_x<?= $Grid->RowIndex ?>_FileName" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_FileName"
        name="x<?= $Grid->RowIndex ?>_FileName"
        class="form-control ew-file-input"
        title="<?= $Grid->FileName->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplatepaymentprocess"
        data-field="x_FileName"
        data-size="500"
        data-accept-file-types="<?= $Grid->FileName->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->FileName->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->FileName->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->FileName->ReadOnly || $Grid->FileName->Disabled) ? " disabled" : "" ?>
        <?= $Grid->FileName->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->FileName->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_FileName" id= "fn_x<?= $Grid->RowIndex ?>_FileName" value="<?= $Grid->FileName->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_FileName" id= "fa_x<?= $Grid->RowIndex ?>_FileName" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_FileName") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_FileName" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_FileName" class="el_projecttemplatepaymentprocess_FileName">
<div id="fd_x<?= $Grid->RowIndex ?>_FileName">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_FileName"
        name="x<?= $Grid->RowIndex ?>_FileName"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->FileName->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplatepaymentprocess"
        data-field="x_FileName"
        data-size="500"
        data-accept-file-types="<?= $Grid->FileName->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->FileName->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->FileName->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->FileName->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->FileName->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_FileName" id= "fn_x<?= $Grid->RowIndex ?>_FileName" value="<?= $Grid->FileName->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_FileName" id= "fa_x<?= $Grid->RowIndex ?>_FileName" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_FileName") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_FileName" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->templateid->Visible) { // templateid ?>
        <td data-name="templateid"<?= $Grid->templateid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->templateid->getSessionValue() != "") { ?>
<span<?= $Grid->templateid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->templateid->getDisplayValue($Grid->templateid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_templateid" name="x<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_templateid" class="el_projecttemplatepaymentprocess_templateid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_templateid"
        name="x<?= $Grid->RowIndex ?>_templateid"
        class="form-select ew-select<?= $Grid->templateid->isInvalidClass() ?>"
        <?php if (!$Grid->templateid->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_templateid"
        <?php } ?>
        data-table="projecttemplatepaymentprocess"
        data-field="x_templateid"
        data-value-separator="<?= $Grid->templateid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->templateid->getPlaceHolder()) ?>"
        <?= $Grid->templateid->editAttributes() ?>>
        <?= $Grid->templateid->selectOptionListHtml("x{$Grid->RowIndex}_templateid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "projecttemplate") && !$Grid->templateid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_templateid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->templateid->caption() ?>" data-title="<?= $Grid->templateid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_templateid" data-url="<?= GetUrl("projecttemplateaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->templateid->getErrorMessage() ?></div>
<?= $Grid->templateid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_templateid") ?>
<?php if (!$Grid->templateid->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplatepaymentprocessgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_templateid", selectId: "fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_templateid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplatepaymentprocessgrid.lists.templateid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplatepaymentprocessgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplatepaymentprocessgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplatepaymentprocess.fields.templateid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_templateid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_templateid" id="o<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->templateid->getSessionValue() != "") { ?>
<span<?= $Grid->templateid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->templateid->getDisplayValue($Grid->templateid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_templateid" name="x<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_templateid" class="el_projecttemplatepaymentprocess_templateid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_templateid"
        name="x<?= $Grid->RowIndex ?>_templateid"
        class="form-select ew-select<?= $Grid->templateid->isInvalidClass() ?>"
        <?php if (!$Grid->templateid->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_templateid"
        <?php } ?>
        data-table="projecttemplatepaymentprocess"
        data-field="x_templateid"
        data-value-separator="<?= $Grid->templateid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->templateid->getPlaceHolder()) ?>"
        <?= $Grid->templateid->editAttributes() ?>>
        <?= $Grid->templateid->selectOptionListHtml("x{$Grid->RowIndex}_templateid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "projecttemplate") && !$Grid->templateid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_templateid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->templateid->caption() ?>" data-title="<?= $Grid->templateid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_templateid" data-url="<?= GetUrl("projecttemplateaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->templateid->getErrorMessage() ?></div>
<?= $Grid->templateid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_templateid") ?>
<?php if (!$Grid->templateid->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplatepaymentprocessgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_templateid", selectId: "fprojecttemplatepaymentprocessgrid_x<?= $Grid->RowIndex ?>_templateid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplatepaymentprocessgrid.lists.templateid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplatepaymentprocessgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplatepaymentprocessgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplatepaymentprocess.fields.templateid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_templateid" class="el_projecttemplatepaymentprocess_templateid">
<span<?= $Grid->templateid->viewAttributes() ?>>
<?= $Grid->templateid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_templateid" data-hidden="1" name="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_templateid" id="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->FormValue) ?>">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_templateid" data-hidden="1" data-old name="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_templateid" id="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Created_Date" class="el_projecttemplatepaymentprocess_Created_Date">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Created_Date" class="el_projecttemplatepaymentprocess_Created_Date">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Created_Date" class="el_projecttemplatepaymentprocess_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_Date" data-hidden="1" name="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_Date" data-hidden="1" data-old name="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Created_By" class="el_projecttemplatepaymentprocess_Created_By">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Created_By" class="el_projecttemplatepaymentprocess_Created_By">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Created_By" class="el_projecttemplatepaymentprocess_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_By" data-hidden="1" name="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Created_By" data-hidden="1" data-old name="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Last_Updated_Date" class="el_projecttemplatepaymentprocess_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplatepaymentprocess_Last_Updated_By" class="el_projecttemplatepaymentprocess_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Last_Updated_By" data-hidden="1" name="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojecttemplatepaymentprocessgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projecttemplatepaymentprocess" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojecttemplatepaymentprocessgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojecttemplatepaymentprocessgrid","load"], () => fprojecttemplatepaymentprocessgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojecttemplatepaymentprocessgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttemplatepaymentprocess");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
