<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjecttemplateresultGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojecttemplateresultgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projecttemplateresult: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojecttemplateresultgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["Activities", [fields.Activities.visible && fields.Activities.required ? ew.Validators.required(fields.Activities.caption) : null], fields.Activities.isInvalid],
            ["Category", [fields.Category.visible && fields.Category.required ? ew.Validators.required(fields.Category.caption) : null], fields.Category.isInvalid],
            ["Weight", [fields.Weight.visible && fields.Weight.required ? ew.Validators.required(fields.Weight.caption) : null, ew.Validators.integer], fields.Weight.isInvalid],
            ["File", [fields.File.visible && fields.File.required ? ew.Validators.fileRequired(fields.File.caption) : null], fields.File.isInvalid],
            ["templateid", [fields.templateid.visible && fields.templateid.required ? ew.Validators.required(fields.templateid.caption) : null], fields.templateid.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["Activities",false],["Category",false],["Weight",false],["File",false],["templateid",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Category": <?= $Grid->Category->toClientList($Grid) ?>,
            "templateid": <?= $Grid->templateid->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojecttemplateresultgrid" class="ew-form ew-list-form">
<div id="gmp_projecttemplateresult" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projecttemplateresultgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->Activities->Visible) { // Activities ?>
        <th data-name="Activities" class="<?= $Grid->Activities->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_Activities" class="projecttemplateresult_Activities"><?= $Grid->renderFieldHeader($Grid->Activities) ?></div></th>
<?php } ?>
<?php if ($Grid->Category->Visible) { // Category ?>
        <th data-name="Category" class="<?= $Grid->Category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_Category" class="projecttemplateresult_Category"><?= $Grid->renderFieldHeader($Grid->Category) ?></div></th>
<?php } ?>
<?php if ($Grid->Weight->Visible) { // Weight ?>
        <th data-name="Weight" class="<?= $Grid->Weight->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_Weight" class="projecttemplateresult_Weight"><?= $Grid->renderFieldHeader($Grid->Weight) ?></div></th>
<?php } ?>
<?php if ($Grid->File->Visible) { // File ?>
        <th data-name="File" class="<?= $Grid->File->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_File" class="projecttemplateresult_File"><?= $Grid->renderFieldHeader($Grid->File) ?></div></th>
<?php } ?>
<?php if ($Grid->templateid->Visible) { // templateid ?>
        <th data-name="templateid" class="<?= $Grid->templateid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_templateid" class="projecttemplateresult_templateid"><?= $Grid->renderFieldHeader($Grid->templateid) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_Created_Date" class="projecttemplateresult_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_Created_By" class="projecttemplateresult_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_Last_Updated_Date" class="projecttemplateresult_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttemplateresult_Last_Updated_By" class="projecttemplateresult_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->Activities->Visible) { // Activities ?>
        <td data-name="Activities"<?= $Grid->Activities->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Activities" class="el_projecttemplateresult_Activities">
<input type="<?= $Grid->Activities->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Activities" id="x<?= $Grid->RowIndex ?>_Activities" data-table="projecttemplateresult" data-field="x_Activities" value="<?= $Grid->Activities->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Grid->Activities->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Activities->formatPattern()) ?>"<?= $Grid->Activities->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Activities->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Activities" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Activities" id="o<?= $Grid->RowIndex ?>_Activities" value="<?= HtmlEncode($Grid->Activities->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Activities" class="el_projecttemplateresult_Activities">
<input type="<?= $Grid->Activities->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Activities" id="x<?= $Grid->RowIndex ?>_Activities" data-table="projecttemplateresult" data-field="x_Activities" value="<?= $Grid->Activities->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Grid->Activities->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Activities->formatPattern()) ?>"<?= $Grid->Activities->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Activities->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Activities" class="el_projecttemplateresult_Activities">
<span<?= $Grid->Activities->viewAttributes() ?>>
<?= $Grid->Activities->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Activities" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Activities" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Activities" value="<?= HtmlEncode($Grid->Activities->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Activities" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Activities" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Activities" value="<?= HtmlEncode($Grid->Activities->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Category->Visible) { // Category ?>
        <td data-name="Category"<?= $Grid->Category->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Category" class="el_projecttemplateresult_Category">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_Category"
        name="x<?= $Grid->RowIndex ?>_Category"
        class="form-select ew-select<?= $Grid->Category->isInvalidClass() ?>"
        <?php if (!$Grid->Category->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_Category"
        <?php } ?>
        data-table="projecttemplateresult"
        data-field="x_Category"
        data-value-separator="<?= $Grid->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Category->getPlaceHolder()) ?>"
        <?= $Grid->Category->editAttributes() ?>>
        <?= $Grid->Category->selectOptionListHtml("x{$Grid->RowIndex}_Category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterprojectcategory") && !$Grid->Category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_Category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->Category->caption() ?>" data-title="<?= $Grid->Category->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_Category" data-url="<?= GetUrl("masterprojectcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->Category->getErrorMessage() ?></div>
<?= $Grid->Category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Category") ?>
<?php if (!$Grid->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplateresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Category", selectId: "fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplateresultgrid.lists.Category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttemplateresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttemplateresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplateresult.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Category" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Category" id="o<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Category" class="el_projecttemplateresult_Category">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_Category"
        name="x<?= $Grid->RowIndex ?>_Category"
        class="form-select ew-select<?= $Grid->Category->isInvalidClass() ?>"
        <?php if (!$Grid->Category->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_Category"
        <?php } ?>
        data-table="projecttemplateresult"
        data-field="x_Category"
        data-value-separator="<?= $Grid->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Category->getPlaceHolder()) ?>"
        <?= $Grid->Category->editAttributes() ?>>
        <?= $Grid->Category->selectOptionListHtml("x{$Grid->RowIndex}_Category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterprojectcategory") && !$Grid->Category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_Category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->Category->caption() ?>" data-title="<?= $Grid->Category->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_Category" data-url="<?= GetUrl("masterprojectcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->Category->getErrorMessage() ?></div>
<?= $Grid->Category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Category") ?>
<?php if (!$Grid->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplateresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Category", selectId: "fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplateresultgrid.lists.Category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttemplateresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Category", form: "fprojecttemplateresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplateresult.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Category" class="el_projecttemplateresult_Category">
<span<?= $Grid->Category->viewAttributes() ?>>
<?= $Grid->Category->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Category" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Category" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Category" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Category" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Category" value="<?= HtmlEncode($Grid->Category->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Weight->Visible) { // Weight ?>
        <td data-name="Weight"<?= $Grid->Weight->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Weight" class="el_projecttemplateresult_Weight">
<input type="<?= $Grid->Weight->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Weight" id="x<?= $Grid->RowIndex ?>_Weight" data-table="projecttemplateresult" data-field="x_Weight" value="<?= $Grid->Weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Weight->formatPattern()) ?>"<?= $Grid->Weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Weight->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Weight" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Weight" id="o<?= $Grid->RowIndex ?>_Weight" value="<?= HtmlEncode($Grid->Weight->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Weight" class="el_projecttemplateresult_Weight">
<input type="<?= $Grid->Weight->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Weight" id="x<?= $Grid->RowIndex ?>_Weight" data-table="projecttemplateresult" data-field="x_Weight" value="<?= $Grid->Weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Weight->formatPattern()) ?>"<?= $Grid->Weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Weight->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Weight" class="el_projecttemplateresult_Weight">
<span<?= $Grid->Weight->viewAttributes() ?>>
<?= $Grid->Weight->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Weight" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Weight" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Weight" value="<?= HtmlEncode($Grid->Weight->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Weight" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Weight" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Weight" value="<?= HtmlEncode($Grid->Weight->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->File->Visible) { // File ?>
        <td data-name="File"<?= $Grid->File->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_projecttemplateresult_File" class="el_projecttemplateresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplateresult"
        data-field="x_File"
        data-size="500"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->File->ReadOnly || $Grid->File->Disabled) ? " disabled" : "" ?>
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_projecttemplateresult_File" class="el_projecttemplateresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplateresult"
        data-field="x_File"
        data-size="500"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_File" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_File" id="o<?= $Grid->RowIndex ?>_File" value="<?= HtmlEncode($Grid->File->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_File" class="el_projecttemplateresult_File">
<span<?= $Grid->File->viewAttributes() ?>>
<?= GetFileViewTag($Grid->File, $Grid->File->getViewValue(), false) ?><div id="tt_projecttemplateresult_x<?= $Grid->RowCount ?>_File" class="d-none">
<?= $Grid->File->TooltipValue ?>
</div>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_File" class="el_projecttemplateresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplateresult"
        data-field="x_File"
        data-size="500"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->File->ReadOnly || $Grid->File->Disabled) ? " disabled" : "" ?>
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_File") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_File" class="el_projecttemplateresult_File">
<div id="fd_x<?= $Grid->RowIndex ?>_File">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_File"
        name="x<?= $Grid->RowIndex ?>_File"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->File->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="projecttemplateresult"
        data-field="x_File"
        data-size="500"
        data-accept-file-types="<?= $Grid->File->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->File->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->File->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->File->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->File->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_File" id= "fn_x<?= $Grid->RowIndex ?>_File" value="<?= $Grid->File->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_File" id= "fa_x<?= $Grid->RowIndex ?>_File" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_File") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_File" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->templateid->Visible) { // templateid ?>
        <td data-name="templateid"<?= $Grid->templateid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->templateid->getSessionValue() != "") { ?>
<span<?= $Grid->templateid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->templateid->getDisplayValue($Grid->templateid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_templateid" name="x<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_templateid" class="el_projecttemplateresult_templateid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_templateid"
        name="x<?= $Grid->RowIndex ?>_templateid"
        class="form-select ew-select<?= $Grid->templateid->isInvalidClass() ?>"
        <?php if (!$Grid->templateid->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_templateid"
        <?php } ?>
        data-table="projecttemplateresult"
        data-field="x_templateid"
        data-value-separator="<?= $Grid->templateid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->templateid->getPlaceHolder()) ?>"
        <?= $Grid->templateid->editAttributes() ?>>
        <?= $Grid->templateid->selectOptionListHtml("x{$Grid->RowIndex}_templateid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "projecttemplate") && !$Grid->templateid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_templateid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->templateid->caption() ?>" data-title="<?= $Grid->templateid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_templateid" data-url="<?= GetUrl("projecttemplateaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->templateid->getErrorMessage() ?></div>
<?= $Grid->templateid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_templateid") ?>
<?php if (!$Grid->templateid->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplateresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_templateid", selectId: "fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_templateid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplateresultgrid.lists.templateid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplateresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplateresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplateresult.fields.templateid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_templateid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_templateid" id="o<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->templateid->getSessionValue() != "") { ?>
<span<?= $Grid->templateid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->templateid->getDisplayValue($Grid->templateid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_templateid" name="x<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_templateid" class="el_projecttemplateresult_templateid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_templateid"
        name="x<?= $Grid->RowIndex ?>_templateid"
        class="form-select ew-select<?= $Grid->templateid->isInvalidClass() ?>"
        <?php if (!$Grid->templateid->IsNativeSelect) { ?>
        data-select2-id="fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_templateid"
        <?php } ?>
        data-table="projecttemplateresult"
        data-field="x_templateid"
        data-value-separator="<?= $Grid->templateid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->templateid->getPlaceHolder()) ?>"
        <?= $Grid->templateid->editAttributes() ?>>
        <?= $Grid->templateid->selectOptionListHtml("x{$Grid->RowIndex}_templateid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "projecttemplate") && !$Grid->templateid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_templateid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->templateid->caption() ?>" data-title="<?= $Grid->templateid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_templateid" data-url="<?= GetUrl("projecttemplateaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->templateid->getErrorMessage() ?></div>
<?= $Grid->templateid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_templateid") ?>
<?php if (!$Grid->templateid->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttemplateresultgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_templateid", selectId: "fprojecttemplateresultgrid_x<?= $Grid->RowIndex ?>_templateid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttemplateresultgrid.lists.templateid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplateresultgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_templateid", form: "fprojecttemplateresultgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttemplateresult.fields.templateid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_templateid" class="el_projecttemplateresult_templateid">
<span<?= $Grid->templateid->viewAttributes() ?>>
<?= $Grid->templateid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_templateid" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_templateid" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_templateid" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_templateid" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_templateid" value="<?= HtmlEncode($Grid->templateid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Created_Date" class="el_projecttemplateresult_Created_Date">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Created_Date" class="el_projecttemplateresult_Created_Date">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Created_Date" class="el_projecttemplateresult_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_Date" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_Date" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Created_By" class="el_projecttemplateresult_Created_By">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Created_By" class="el_projecttemplateresult_Created_By">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Created_By" class="el_projecttemplateresult_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_By" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Created_By" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Last_Updated_Date" class="el_projecttemplateresult_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projecttemplateresult_Last_Updated_By" class="el_projecttemplateresult_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projecttemplateresult" data-field="x_Last_Updated_By" data-hidden="1" name="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojecttemplateresultgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projecttemplateresult" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojecttemplateresultgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojecttemplateresultgrid","load"], () => fprojecttemplateresultgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->Activities->Visible) { // Activities ?>
        <td data-name="Activities" class="<?= $Grid->Activities->footerCellClass() ?>"><span id="elf_projecttemplateresult_Activities" class="projecttemplateresult_Activities">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Category->Visible) { // Category ?>
        <td data-name="Category" class="<?= $Grid->Category->footerCellClass() ?>"><span id="elf_projecttemplateresult_Category" class="projecttemplateresult_Category">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Weight->Visible) { // Weight ?>
        <td data-name="Weight" class="<?= $Grid->Weight->footerCellClass() ?>"><span id="elf_projecttemplateresult_Weight" class="projecttemplateresult_Weight">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->Weight->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->File->Visible) { // File ?>
        <td data-name="File" class="<?= $Grid->File->footerCellClass() ?>"><span id="elf_projecttemplateresult_File" class="projecttemplateresult_File">
        </span></td>
    <?php } ?>
    <?php if ($Grid->templateid->Visible) { // templateid ?>
        <td data-name="templateid" class="<?= $Grid->templateid->footerCellClass() ?>"><span id="elf_projecttemplateresult_templateid" class="projecttemplateresult_templateid">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date" class="<?= $Grid->Created_Date->footerCellClass() ?>"><span id="elf_projecttemplateresult_Created_Date" class="projecttemplateresult_Created_Date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By" class="<?= $Grid->Created_By->footerCellClass() ?>"><span id="elf_projecttemplateresult_Created_By" class="projecttemplateresult_Created_By">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->footerCellClass() ?>"><span id="elf_projecttemplateresult_Last_Updated_Date" class="projecttemplateresult_Last_Updated_Date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->footerCellClass() ?>"><span id="elf_projecttemplateresult_Last_Updated_By" class="projecttemplateresult_Last_Updated_By">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojecttemplateresultgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttemplateresult");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
